# encoding=utf-8
"""
功 能：恢复管理面数据库软件工具
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2020-07-20 16:22 创建
"""

import os
import sys
import json
import shlex
import subprocess

from util import ossext
from util import httpclient

DEFAULT_TIMEOUT = 3600

def get_backup_node_info():
    """
     功能描述：查询备份服务器信息
    :return: 备份服务器数据
    """
    try:
        _httpclient = httpclient.IRHttpClient()
        _url = '/rest/plat/brmgr/v1/main/baseinfo/bssinfo'
        status, content = _httpclient.post(_url)
        backup_node_info = {}
        if status == 200:
            backup_list = json.loads(content.decode())
            if len(backup_list) > 0:
                json_data = json.loads(content.decode())[0]
                backup_node_info.update({
                    "server_ip": json_data["ftpServerIP"],
                    "server_user": json_data["ftpUsername"],
                    "ftp_pvalue": json_data["ftpPvalue"],
                    "backup_path": json_data["configedBackupPath"]
                })
        return backup_node_info
    except Exception:
        return {}

def download_backup_pkg(sftp_download):
    """
     功能描述：下载管理面备份文件
    :param sftp_download: 下载工具脚本
    :return: 下载结果
    """
    backup_node_info = get_backup_node_info()
    if backup_node_info == {}:
        return ""

    server_ip = backup_node_info["server_ip"]
    server_user = backup_node_info["server_user"]
    ftp_pvalue = ossext.Cipher.decrypt(backup_node_info["ftp_pvalue"])
    backup_path = backup_node_info["backup_path"]

    log_path = "/opt/oss/log/manager/easysuite_upgrade"
    if not os.path.isdir(log_path):
        os.makedirs(log_path)

    cmd = "bash %s %s %s %s >%s/sftp_download.log" % \
          (sftp_download, server_ip, server_user, backup_path, log_path)
    p = subprocess.Popen(shlex.split(cmd),
                         shell=False, encoding='utf-8',
                         stdin=subprocess.PIPE,
                         stderr=subprocess.PIPE,
                         stdout=subprocess.PIPE)
    p.stdin.write(ftp_pvalue)
    p.stdin.flush()
    stdout, stderr = p.communicate(timeout=DEFAULT_TIMEOUT)
    ret_code = p.returncode

    if ret_code == 0:
        return "DOWNLOAD_SUCCESS"
    return "DOWNLOAD_FAILED"

def get_ha_access_ip(access_file):
    """
     功能描述：获取主备OMP节点间IP
    :param access_file: 配置文件
    :return: 节点数据
    """
    def get_omp_ip(node_info):
        """
        功能描述：获取OMP节点间IP
        :param node_info: OMP节点信息
        :return:OMP节点ip
        """
        for ip_info in node_info.get("IPAddresses", []):
            usages = ip_info.get("usage", [])
            if "maintenance" in usages:
                return ip_info.get("IP", "")
        return ""

    json_file = None
    try:
        json_file = open(access_file, encoding='utf-8')
        json_data = json.loads(json_file.read())

        node_info = json_data.get("nodeList", {})

        omp_node_0 = get_omp_ip(node_info.get("0", {}))
        omp_node_1 = get_omp_ip(node_info.get("1", {}))

        return "0,%s;1,%s" % (omp_node_0, omp_node_1)
    except Exception:
        return ""
    finally:
        if json_file is not None:
            json_file.close()


def get_manage_node():
    """
    获取管理节点名称
    :return:
    """
    manage_node_num = 1
    with open('/opt/oss/manager/var/agent/managerip.conf', 'r', encoding='utf-8') as r_stream:
        first_line = r_stream.readline()
        if ',' in first_line:
            manage_node_num = 2
    manage_node = []
    with open('/opt/oss/manager/etc/sysconf/nodelists.json', 'r', encoding='utf-8') as r_stream:
        node_list_data = json.load(r_stream)
        manage_node.append(node_list_data.get("nodeList").get("0").get("hostname"))
        if manage_node_num == 2:
            manage_node.append(node_list_data.get("nodeList").get("1").get("hostname"))
    return ','.join(manage_node)


def main(argv):
    """
     功能描述：程序入口
    :param argv: 参数
    :return: 运行结果
    """
    if argv[1] == "get_ha_access_ip":
        print(get_ha_access_ip(argv[2]))
        return 0
    if argv[1] == "download_backup_pkg":
        print(download_backup_pkg(argv[2]))
        return 0
    if argv[1] == "get_manage_node":
        print(get_manage_node())
        return 0
    return 0

if __name__ == '__main__':
    main(sys.argv)

