#!/bin/bash

#脚本所在路径
SCRIPT_PATH=$(cd $(dirname $0);pwd)

# 创建ossadm目录
function create_with_ossadm()
{
    # 目录不存在
    mkdir -p /opt/upgrade_upload
    # 目录不存在清理
    [ -d /opt/upgrade_upload -a ! -L /opt/upgrade_upload ] && chown ossadm:ossgroup /opt/upgrade_upload && chmod 750 /opt/upgrade_upload

    return 0
}

# 创建sopuser目录
function create_with_sopuser()
{
    # 目录不存在
    mkdir -p /opt/upgrade_upload
    # 目录不存在清理
    [ -d /opt/upgrade_upload -a ! -L /opt/upgrade_upload ] && chown ossadm:ossgroup /opt/upgrade_upload && chmod 750 /opt/upgrade_upload && chown $(id -un sopuser 2>/dev/null || echo ossadm) /opt/upgrade_upload

    return 0
}



# 主入口
function main()
{
    # 加载公共方法
    source ${SCRIPT_PATH}/common.sh

    # 检查脚本执行用户
    check_user || return $?

    action="${1}"
    case ${action} in
    'create_with_ossadm')
        create_with_ossadm
    ;;
    'create_with_sopuser')
        create_with_sopuser
    ;;
    esac
}

main "$@"
exit $?