#!/bin/bash

#脚本所在路径
CURRENT_SCRIPT_PATH=$(cd $(dirname $0);pwd)
# 脚本目录
SCRIPT_PATH="/opt/upgrade"
# 其他用户
OTHER_USER="sopuser"


# 检查脚本执行用户
function check_user()
{
    local user
    user=$(whoami)
    if [ "${user}" != "root" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

# 设置升级目录下文件和目录权限为ossadm
function set_ossadm_permit()
{
    # R21C00及之后版本支持setfacl属性
    id ${OTHER_USER} && su - ${OTHER_USER} <<END
# 不同权限的文件或目录添加不同的权限
# 文件部分
find ${SCRIPT_PATH} -type f -user ${OTHER_USER} -perm /u+x 2>/dev/null | grep -E "^${SCRIPT_PATH}" | xargs -i setfacl -m u:ossadm:rwx '{}'
find ${SCRIPT_PATH} -type f -user ${OTHER_USER} ! -perm /u+x 2>/dev/null | grep -E "^${SCRIPT_PATH}" | xargs -i setfacl -m u:ossadm:rw '{}'

# 目录部分,必须有x权限否则无法进行cd以及删除操作
find ${SCRIPT_PATH} -type d -user ${OTHER_USER} 2>/dev/null | grep -E "^${SCRIPT_PATH}" | xargs -i setfacl -m u:ossadm:rwx '{}'
END

return 0
}


# 主入口
function main()
{
    # 加载公共方法
    source ${CURRENT_SCRIPT_PATH}/common.sh

    # 检查脚本执行用户
    check_user || return $?

    # 创建升级目录
    set_ossadm_permit "$@"
}

main "$@"
exit $?


