#!/bin/bash

#脚本所在路径
SCRIPT_PATH=$(cd $(dirname $0);pwd)

# 检查脚本执行用户
function check_user()
{
    local user
    user=$(whoami)
    if [ "${user}" != "root" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

function register()
{
    # Suse场景
    if [ -e /etc/SuSE-release ]
    then
        sed -i "/tool_reboot_ospatch_tmp.sh/d" /etc/rc.d/after.local
        echo 'su - ossadm -c "nohup bash /opt/upgrade/easysuite_upgrade/scripts/common/NCE-Common/os/tool_reboot_ospatch_tmp.sh &"' >>/etc/rc.d/after.local
        chmod +x /etc/rc.d/after.local
    fi

    # Euler or Centos 场景
    if [ -e /etc/centos-release -o -e /etc/euleros-release ]
    then
        sed -i "/tool_reboot_ospatch_tmp.sh/d" /etc/rc.d/rc.local
        echo 'su - ossadm -c "nohup bash /opt/upgrade/easysuite_upgrade/scripts/common/NCE-Common/os/tool_reboot_ospatch_tmp.sh &"' >>/etc/rc.d/rc.local
        chmod +x /etc/rc.d/rc.local
    fi
}

function clear()
{
    # Suse场景
    if [ -e /etc/SuSE-release ]
    then
        sed -i "/tool_reboot_ospatch_tmp.sh/d" /etc/rc.d/after.local
    fi

    # Euler or Centos 场景
    if [ -e /etc/centos-release -o -e /etc/euleros-release ]
    then
        sed -i "/tool_reboot_ospatch_tmp.sh/d" /etc/rc.d/rc.local
    fi
}

# 主入口
function main()
{
    # 加载公共方法
    source ${SCRIPT_PATH}/common.sh

    # 检查脚本执行用户
    check_user || return $?

    action="${1}"
    case ${action} in
    'register')
        register
    ;;
    'clear')
        clear
    ;;
    esac
}

main "$@"
exit $?