#!/bin/bash

# 磁盘单位转换为：G
disksize_convert_to_g()
{
    size=$1
    size_g=0
    if [[ ${size} =~ "K" ]]; then
        si ze=`echo ${size} | cut -d'K' -f1` > /dev/null 2>&1
        size_g=$[ size / 1000 / 1000 ]
    elif [[ ${size} =~ "M" ]]; then
        si ze=`echo ${size} | cut -d'M' -f1` > /dev/null 2>&1
        size_g=$[ size / 1000 ]
    elif [[ ${size} =~ "G" ]]; then
        size=`echo ${size} | cut -d'G' -f1` > /dev/null 2>&1
        size_g=${size}
    elif [[ ${size} =~ "T" ]]; then
        size=`echo ${size} | cut -d'T' -f1` > /dev/null 2>&1
        size_g=$[ size * 1000 ]
    fi

    echo ${size_g};
}

# 磁盘比较单位：G
check_disk()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking disk."
    current_dir=$(cd $(dirname $0);pwd)
    dir_path=${current_dir}/../../conf/fi_dir_check.conf
    [[ ! -f ${dir_path} ]] && fn_sys_log_error "File not find error." && return 1

    for line in $(cat ${dir_path}); do
        path_fi=$(echo ${line} | awk -F ';' '{print $1}')
        disk_fi=$(echo ${line} | awk -F ';' '{print $2}')
        user_fi=$(echo ${line} | awk -F ';' '{print $3}')
        pers_fi=$(echo ${line} | awk -F ';' '{print $4}')

        if [[ ! -d ${path_fi} ]]; then
            mkdir -p ${path_fi}
        fi
        chown -R ${user_fi} ${path_fi}
        chmod -R ${pers_fi} ${path_fi}

        # 磁盘大小判断
        current_disk_size=`df -h | grep "${path_fi}$" |awk -F" " '{print $4}'` > /dev/null 2>&1
        res=$?
        [[ ${res} -ne 0 ]] && fn_sys_log_error "${host_ip}: No disk is mounted to the [${path_fi}], which does not meet the requirement."
        current_disk_size_g=$(disksize_convert_to_g ${current_disk_size})
        [[ ${current_disk_size_g} -lt ${disk_fi} ]] && fn_sys_log_error "[${path_fi}] The disk size is  ${current_disk_size_g} GB, which does not meet the requirement."

    done
    fn_sys_log_info "${host_ip}: Disk check success."
    return 0
}


