#!/bin/bash

check_ipmitool()
{   
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking ipmitool command."
    
    tmpstr=$(ipmitool -V)
    local retval=$?
    if [[ $retval -ne 0 ]]; then
        fn_sys_log_error "${host_ip}: check ipmitool command failed, return $retval."
        
        ##־
        fn_sys_log_error "${host_ip}: ipmitool command check failed. Please perform the preinstall operation."
    fi
    fn_sys_log_info "${host_ip}: Success checking ipmitool command."
}

check_iostat()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking iostat command."
    
    tmpstr=$(iostat)
    local retval=$?
    if [[ $retval -ne 0 ]]; then
        fn_sys_log_error "${host_ip}: check iostat command failed, return $retval."
        
        ##־
        fn_sys_log_error "${host_ip}: iostat command check failed. Please perform the preinstall operation."
    fi
    fn_sys_log_info "${host_ip}: Success checking iostat command."
}

