#!/bin/bash

check_local_port_range()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start to check the random port range of the OS."
    
    #获取OS随机端口范围的最小值
    local minPort=$(cat /proc/sys/net/ipv4/ip_local_port_range | awk '{print $1}')

    #FI使用（包括预留）的端口范围的最大值为32767，为避免端口冲突，OS随机端口范围的下限不得小于32768
    if [[ ${minPort} -lt ${MIN_IP_LOCAL_PORT_ID} ]]; then
        fn_sys_log_error "${host_ip}: The start port ID must be equal or greater than 32768."
    fi
    fn_sys_log_info "${host_ip}: Success to check the random port range of the OS."
}
