#!/bin/bash -

######################################################################################
#_$1: Required. Property file absolution path
#_$2: Required. Property key
# Return: Property value
function fn_sys_read_property()
{
    local l_property_file="$1"
    local l_property_key="$2"

    if [ ! -f "$l_property_file" ]; then
        echo ""
    fi

    if [ ! -e "$l_property_file" ]; then
        echo ""
    fi

    cat "$l_property_file" | grep "^[[:blank:]]*${l_property_key}[[:blank:]]*=[[:blank:]]*.*$" | sed "s#\(^[[:blank:]]*${l_property_key}[[:blank:]]*=[[:blank:]]*\)\(.*$\)#\2#g;s/[[:blank:]]*$//g"

    return 0
}

###############################################################################################
#_$1: Required. Property file absolution path
#_$2: Required. Property key
#_$3: Required. Property value
function fn_sys_set_property()
{
    local l_property_file="$1"
    local l_property_key="$2"
    local l_property_value="$3"

    fn_sys_assert_is_file "l_property_file" || return 1

    cat "$l_property_file" | grep "^[[:blank:]]*${l_property_key}[[:blank:]]*=[[:blank:]]*.*$" &> /dev/null
    if [ "$?" -eq 0 ]; then
        sed -i "s#^[[:blank:]]*${l_property_key}[[:blank:]]*=[[:blank:]]*.*#${l_property_key}=${l_property_value}#g" "$l_property_file"
    else
        echo "${l_property_key}=${l_property_value}" >> "$l_property_file"
    fi

    return "$?"
}

###############################################################################################
function fn_sys_in()
{
    local l_value_list="$1"   # delimited by ','
    local l_value="$2"

    [ -z "$l_value" ] && echo "false" && return 0

    echo "$l_value_list" | awk -F',' '{ for(i=1;i<=NF;i++) print $i }' | grep "^${l_value}$" &> /dev/null
    [ "$?" -eq 0 ] && echo "true" && return 0

    echo "false"
    return 0
}

###############################################################################################
function fn_sys_is_valid_number()
{
    local l_number="$1"
    [ -z "$l_number" ] && echo "false" && return 0

    [ "$l_number" == "0" ] && echo "true" && return 0
    expr $l_number + 0 &> /dev/null
    if [ "$?" -ne 0 ]; then
        echo "false"
    else
        echo "true"
    fi

    return 0
}

###############################################################################################
function fn_sys_string_contains_space()
{
    local l_string="$1"

    echo "$l_string" | grep '[[:blank:]]' &> /dev/null
    [ "$?" -eq "0" ] && echo "true" && return 0

    echo "false"
    return 0
}

###############################################################################################
function fn_sys_get_var_value()
{
    local l_var_name="$1"
    echo ${!l_var_name}
    return 0
}

###############################################################################################
function fn_sys_get_elapsed_time()
{
    local l_start_time="$1"
    l_current_time="$(date +%s)"
    l_elapsed_seconds=$((l_current_time-l_start_time))
    echo "$l_elapsed_seconds"

    return 0
}

###############################################################################################
function fn_sys_is_reserved_user()
{
    local l_user_name="$1"
    local readonly c_reserved_user_list="root,ossuser,ossadm,dbuser"
    if [ "$(fn_sys_in "$c_reserved_user_list" "$l_user_name")" == "true" ]; then
        echo "true"
    else
        echo "false"
    fi

    return 0
}

###############################################################################################
function fn_sys_get_py_script_name()
{
    local l_py_script_path="$1"

    [ -f "${l_py_script_path}c" ] && echo "${l_py_script_path}c" && return 0

    echo "$l_py_script_path"

    return 0
}

###############################################################################################
function fn_sys_is_number_in_range()
{
    local l_number="$1"
    local l_min_value="$2"
    local l_max_value="$3"
    local l_include_min_value="${4:-true}"
    local l_include_max_value="${5:-true}"

    [ "$(fn_sys_is_valid_number "$l_number")" != "true" ] && echo "false" && return 1
    [ "$(fn_sys_is_valid_number "$l_min_value")" != "true" ] && echo "false" && return 1
    [ "$(fn_sys_is_valid_number "$l_max_value")" != "true" ] && echo "false" && return 1

    if [ "$l_include_min_value" == "true" ] && [ "$l_include_max_value" == "true" ]; then
        [ "$l_number" -ge "$l_min_value" ] && [ "$l_number" -le "$l_max_value" ] && echo "true" && return 0
    elif [ "$l_include_min_value" == "true" ] && [ "$l_include_max_value" == "false" ]; then
        [ "$l_number" -ge "$l_min_value" ] && [ "$l_number" -lt "$l_max_value" ] && echo "true" && return 0
    elif [ "$l_include_min_value" == "false" ] && [ "$l_include_max_value" == "true" ]; then
        [ "$l_number" -gt "$l_min_value" ] && [ "$l_number" -le "$l_max_value" ] && echo "true" && return 0
    elif [ "$l_include_min_value" == "false" ] && [ "$l_include_max_value" == "false" ]; then
        [ "$l_number" -gt "$l_min_value" ] && [ "$l_number" -lt "$l_max_value" ] && echo "true" && return 0
    else
        echo "false"
        return 1
    fi

    echo "false"
    return 1
}

###################################################
#
# 进程已经在执行，不要重复执行
#
###################################################
fn_process_is_runing()
{
    local process_identity="$1"
    [[ $(ps -efww | grep "${process_identity}" | grep -v grep | grep  -v $$ | wc -l) -ne 0 ]] && echo "The process is being executed. Do not run the process again." && return 1
    return 0
}