#!/bin/bash

CUR_PATH=$(cd `dirname $0`;pwd)
cd ${CUR_PATH}
. ./controller.sh
. ./check_network_config_order.sh
. ./check_hostname.sh

################################################################################
# name    :    main
# describe:    main function of check environment about MDSP
# parameter list: null
# input      : null
# output  : 0 success 1 failure
# rerurn  : null
# invoker : main
################################################################################
#step1: check Partition

function main()
{
    #the variable count the fail time of check step
    typeset -i fail_num=0
    # generate conf to param
    flag_file=/root/EasySuite/888/conf/config.properties
    #step0: 在主节点和扩容节点都执行网络检查的init_param
    check_network_config
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[successfully] Checking network config successfully !"
    fi
    echo "custom_check_network_configuration"

    if [ ${fail_num} -gt 0 ]
    then
        echo "===========================CHECKING ENVIRONMENT FAILED=============================="
        echo "===================================================================================="
        echo 'check_env_order_sh_flag=1' >> ${flag_file}
        rm -rf /opt/install_check
        return 1
    fi

    if [[ $1 == "main_fi_fabric" ]]
    then
        #step11: 在主节点上hostname是否重复 如果init_param脚本执行失败，则脚本需要的信息都获取不到，故不检测
        echo "custom_check_hostname"
        check_hostname
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking hostname successfully !"
        fi
        echo "custom_check_hostname"
    fi

    if [ ${fail_num} -gt 0 ]
    then
        echo "===========================CHECKING ENVIRONMENT FAILED=============================="
        echo "===================================================================================="
        echo 'check_env_order_sh_flag=1' >> ${flag_file}
        rm -rf /opt/install_check
        return 1
    else
        echo "===========================CHECKING ENVIRONMENT SUCCESSFULLY========================"
        echo "===================================================================================="
        echo 'check_env_order_sh_flag=0' >> ${flag_file}
        return 0
    fi
}

# os_pwd_root
IFS=$'\n'
echo "es_input: os_pwd_root"
read -sr os_root_user_pwd


#execute main function
main "$@"
