#!/bin/bash
logger -t $USER -p local0.info "${OPERIP:-127.0.0.1};Start osconfig rollbackup script"
#get absolute path
FileName="`basename $0`"
RELATIVE_PATH="$(dirname $0)"
cd "${RELATIVE_PATH}"
ABSOLUTELY_PATH=`pwd`
cd - &> /dev/null

USER=`whoami`
OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
[ -z "${WORK_USER}" ] && WORK_USER='ossadm'
if [ "${USER}" = "ossadm" ]
then
    echo > /dev/null
else
    echo "Only ossadm can run this command."
    logger -t $USER -p local0.err "$FileName;Failed;${OPERIP:-127.0.0.1};Only ossadm can run this command."
    exit 1
fi

function fn_restore_perm()
{
    cat "${ABSOLUTELY_PATH}/logs/rollbackup.log" >> "${ABSOLUTELY_PATH}/logs/osconfig_rollbackup.log"
    if [ "${USER}" != "${WORK_USER}" ]
    then
        sudo -u "${WORK_USER}" rm -f "${ABSOLUTELY_PATH}/logs/rollbackup.log"
    else
        rm -f "${ABSOLUTELY_PATH}/logs/rollbackup.log"
    fi

    find "${ABSOLUTELY_PATH}/logs" -type f -exec chmod 640 {} + &>/dev/null
    chmod 750  "${ABSOLUTELY_PATH}/logs/tmp" 2> /dev/null
    chmod 750  "${ABSOLUTELY_PATH}/logs"    2> /dev/null
}

function fn_main()
{
    if [ "${USER}" != "${WORK_USER}" ]
    then
        if [ ! -d "${ABSOLUTELY_PATH}/logs" ]
        then
            mkdir  "${ABSOLUTELY_PATH}/logs"
            mkdir  "${ABSOLUTELY_PATH}/logs/tmp"
        fi
        chmod 750 "${ABSOLUTELY_PATH}/logs"
        chmod 750 "${ABSOLUTELY_PATH}/logs/tmp"
        chmod 440 "${ABSOLUTELY_PATH}/common.inc"
        sudo -u "${WORK_USER}" bash "${ABSOLUTELY_PATH}/rollbackup.sh" $@
    else
        bash "${ABSOLUTELY_PATH}/rollbackup.sh" $@
    fi
    ret=$?

    return "$ret"
}

fn_main "$@"
RET_MAIN=$?
fn_restore_perm
logger -t $USER -p local0.info "${OPERIP:-127.0.0.1};End to osconfig rollbackup script"
exit ${RET_MAIN}
