#!/bin/bash
#get absolute path
FileName="`basename $0`"
RELATIVE_PATH="$(dirname $0)"
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`

MODULE_NAME="`basename $0 | sed 's/\.sh$//'`"
#import common variable..
. ./common.inc
cd - &> /dev/null

function check_os_type() {
    # if getostype.sh not exists, return.
    [[ ! -f "/usr/local/osconfig/os/bin/getostype.sh" ]] && return 0
    local os_type=$(bash /usr/local/osconfig/os/bin/getostype.sh)
    PRINT_LOG "INFO" "The ostype is '${os_type}'" &> /dev/null

    # only deal with euler suse
    [[ ! ${os_type} =~ "SuSE"  &&  ! ${os_type} =~ "EulerOS" ]] && return 0
    [[ ${os_type} =~ "EulerOS-V" ]] && return 0

    ls ${ABSOLUATELY_PATH} | grep "custom-${os_type}" &> /dev/null && return 0

    PRINT_LOG "FATAL" "The osconfig package not match the ostype:${os_type}"
    return 2
}

function check_version() {
    old_release_version=/usr/local/osconfig/os/bin/release_version.properties
    new_release_version="${ABSOLUATELY_PATH}/package/release_version.properties"
    [ ! -f "${old_release_version}" -o ! -f "${new_release_version}" ] && return 0

    old_version=$(grep release_version "${old_release_version}" | awk -F'=' '{print $2}')
    new_version=$(grep release_version "${new_release_version}" | awk -F'=' '{print $2}')
    [[ "${old_version}" =~ ^[0-9]+\.[0-9]+\.[0-9]+$ ]] || { PRINT_LOG "WARN" "old version is invalid" &> /dev/null; return 0;  }
    [[ "${new_version}" =~ ^[0-9]+\.[0-9]+\.[0-9]+$ ]] || { PRINT_LOG "WARN" "new version is invalid" &> /dev/null; return 0;  }
    PRINT_LOG "INFO" "old version:${old_version}, new version:${new_version}" &> /dev/null

    old_ver_arr=(${old_version//./ })
    new_ver_arr=(${new_version//./ })

    local i=0
    while [ $i -le "${#old_ver_arr[@]}" ]
    do
        if [[ "${new_ver_arr[$i]}" -lt "${old_ver_arr[$i]}" ]]
        then
            PRINT_LOG "FATAL" "upgrade the new version:[${new_version}] can not lower than old version:[${old_version}]"
            return 3
        elif [[ "${new_ver_arr[$i]}" -gt "${old_ver_arr[$i]}" ]]
        then
            return 0
        fi
         let i++
    done

    return 0
}

function fn_main()
{
    check_os_type || return $?
    check_version || return $?
}

fn_main $@
exit $?
