#!/bin/bash
#get absolute path 
FileName="`basename $0`"
RELATIVE_PATH="$(dirname $0)"
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`

MODULE_NAME="`basename $0 | sed 's/\.sh$//'`"
#import common variable..
. ./common.inc
cd - &> /dev/null


function fn_clean_sudo_script()
{
    local sudopath="$1"
    PRINT_LOG "INFO" "Start to clean install sudo script." &> /dev/null
    sudo "${sudopath}"/clean_osconfig_gpg_check_sudo.sh &> "${TMP_CONTENT_FILE}"
    PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
    PRINT_LOG "INFO"  "Clean install sudo script done." &> /dev/null
}

function fn_get_python_pkg()
{
    local osVersion="$1"
    PRINT_LOG "INFO" "Query the python installation package, the osVersion is <${osVersion}>" &>/dev/null
    
    local pkgList=$(ls -a1 "${ABSOLUATELY_PATH}" | grep "^python-.*.zip$" | xargs)
    if [ -z "${pkgList}" ]
    then
        PRINT_LOG "FATAL" "Python installation package (python-xxx.zip) not found."
        return 1
    fi
    
    #Note: match ostype-osversion python package
    local pkgList=$(ls -a1 "${ABSOLUATELY_PATH}" | grep "^python-.*${osVersion}.zip$" | head -1 | xargs)
    if [ ! -z "${pkgList}" ]
    then
        eval $2="\${pkgList}"
        PRINT_LOG "INFO" "The python install package <${pkgList}> is exist." &> /dev/null
        return 0
    fi
    
    #Note: match ostype python package
    local cur_ostype=$(echo "${osVersion}" | awk -F'-' '{print $1}')
    echo ${cur_ostype} | egrep -i "^EulerOS" &>/dev/null
    if [ $? -eq 0 ]
    then
        cur_ostype="EulerOS"
    fi
    
    local pkgList=$(ls -a1 "${ABSOLUATELY_PATH}" | grep "^python-.*-${cur_ostype}.zip$" | head -1 | xargs)
    if [ ! -z "${pkgList}" ]
    then
        eval $2="\${pkgList}"
        PRINT_LOG "INFO" "The python install package <${pkgList}> is exist." &> /dev/null
        return 0
    fi
    
    #Note: match no ostype python package
    local pkgList=$(ls -a1 "${ABSOLUATELY_PATH}" | egrep "^python-[0-9\.]+.zip$" | head -1 | xargs)
    if [ ! -z "${pkgList}" ]
    then
        eval $2="\${pkgList}"
        PRINT_LOG "INFO" "The python install package <${pkgList}> is exist." &> /dev/null
        return 0
    fi

    local pkgList=$(ls -a1 "${ABSOLUATELY_PATH}" | egrep "^python-[0-9a-zA-Z\._\-]+.zip$" | head -1 | xargs)
    if [ ! -z "${pkgList}" ]
    then
        eval $2="\${pkgList}"
        PRINT_LOG "INFO" "The python install package <${pkgList}> is exist." &> /dev/null
        return 0
    fi
    
    PRINT_LOG "FATAL" "Failed to get python installation package."
    return 1
}

function install_binary_tool()
{
    local os_type="$1"
    os_tag="EulerOSX86"
    get_os_tag "${os_type}" os_tag
    local binary_pkg="${ABSOLUATELY_PATH}/default-binary-${os_tag}.zip"
    if [[ ! -f "${binary_pkg}" ]]
    then
        PRINT_LOG "FATAL" "binary pkg <binary_pkg> does exit."
        return 1
    fi
    unzip -o ${binary_pkg}  -d /usr/local/osconfig &> ${TMP_CONTENT_FILE}
    if [ $? -ne 0 ]
    then
        PRINT_LOG "FATAL" "Excute the command <unzip -o ${binary_pkg} -d /usr/local/osconfig> failure."
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
        return 1
    fi
    PRINT_LOG "INFO" "Install <${binary_pkg}> package done"
    return 0
}

function get_os_tag()
{
    local os_type="${1}"
    machine_type=$(uname -m)
    if [[ "${machine_type}" == "aarch64" ]]
    then
        os_tag="EulerOSArm"
    elif [[ "${os_type}" =~ "SuSE12" ]]
    then
        os_tag="SuSE12"
    else
        os_tag="EulerOSX86"
    fi
    PRINT_LOG "INFO" "os tag: ${os_tag}" &> /dev/null
    eval ${2}="\${os_tag}"
}

function fn_install_os_tool()
{
    local sudobin_path="$1"
    local os_type="$2"
    os_tag="SuSE12"

    get_os_tag "${os_type}" os_tag

    local ostool_common_pkg="ostool-default-${os_tag}.zip"
    if [[ ! -f "${ostool_common_pkg}" ]]
    then
        PRINT_LOG "FATAL" "The ostool common install package does not exist."
        return 1
    fi

    local os_flag=$(echo ${os_type} | awk -F '-' '{print $1}')
    local ostool_default_pkg_list=$(cd "${ABSOLUATELY_PATH}";ls -1 ostool-default-${os_flag}-*.zip 2> /dev/null)
    local ostool_custom_pkg=$(cd "${ABSOLUATELY_PATH}"; ls -1 | grep -v "^ostool-default-${os_type}.zip$" | grep "^ostool-.*-${os_type}.zip$" | head -1 | xargs)
    local ret
    local sudobin_path=$(echo "${sudobin_path}" | sed -r 's#/+#/#g' | sed 's#/$##')
    if [ -z "${ostool_default_pkg_list}" ]
    then
        PRINT_LOG "WARN" "The OS tool default install package does not exist, skip to install OS tool." &>/dev/null
    else
        # Note: 安装默认加固包
        PRINT_LOG "INFO" "Start to install <${ostool_default_pkg_list}> package..."
        for ostool_pkg in ${ostool_default_pkg_list}
        do
            sudo "${sudobin_path}/execute.sh" "${ABSOLUATELY_PATH}/sudobin_pkg.tar" "decompress_package.sh" "${sudobin_path}" "${ABSOLUATELY_PATH}/${ostool_pkg}" &> "${TMP_CONTENT_FILE}"
            ret=$?
            if [ ${ret} -ne 0 ]
            then
                PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
                PRINT_LOG "FATAL" "Exec<sudo '${sudobin_path}/execute.sh' '${ABSOLUATELY_PATH}/sudobin_pkg.tar' '${tmp_sudo_path}' 'decompress_package.sh' '${sudobin_path}' '${ABSOLUATELY_PATH}/${ostool_pkg}'> failure."
                return ${ret}
            fi
            PRINT_LOG "INFO" "Install <${ostool_pkg}> package done."
        done
    fi

    if [ ! -f "${ostool_custom_pkg}" ]
    then
        PRINT_LOG "INFO" "The OS tool custom install package <${ostool_custom_pkg}> does not exist." &> /dev/null
    else
        # Note: 安装产品定制加固包
        PRINT_LOG "INFO" "Start to install <${ostool_custom_pkg}> package..."
        sudo "${sudobin_path}/execute.sh" "${ABSOLUATELY_PATH}/sudobin_pkg.tar" "decompress_package.sh" "${sudobin_path}" "${ABSOLUATELY_PATH}/${ostool_custom_pkg}" "${os_type}" &> "${TMP_CONTENT_FILE}"
        ret=$?
        if [ ${ret} -ne 0 ]
        then
            PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
            PRINT_LOG "FATAL" "Exec<sudo '${sudobin_path}/execute.sh' '${ABSOLUATELY_PATH}/sudobin_pkg.tar' '${tmp_sudo_path}' 'decompress_package.sh' '${sudobin_path}' '${ABSOLUATELY_PATH}/${ostool_custom_pkg}'> failure."
            return ${ret}
        fi
        PRINT_LOG "INFO" "Install <${ostool_custom_pkg}> package done."
    fi

    # Note: 安装默认加固包
    PRINT_LOG "INFO" "Start to install <${ostool_common_pkg}> package..."
    local tmp_sudo_path="/tmp/osconfig_${RANDOM}_$$"
    sudo "${sudobin_path}/execute.sh" "${ABSOLUATELY_PATH}/sudobin_pkg.tar" "${tmp_sudo_path}" "decompress_package.sh" "${sudobin_path}" "${ABSOLUATELY_PATH}/${ostool_common_pkg}" &> "${TMP_CONTENT_FILE}"
    if [ $? -ne 0 ]
    then
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        PRINT_LOG "FATAL" "Exec<sudo '${sudobin_path}/execute.sh' '${ABSOLUATELY_PATH}/sudobin_pkg.tar' '${tmp_sudo_path}' 'decompress_package.sh' '${sudobin_path}' '${ABSOLUATELY_PATH}/${ostool_common_pkg}'> failure."
        return 1
    fi
    PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &>/dev/null
    PRINT_LOG "INFO" "Install <${ostool_common_pkg}> package done."

    return 0
}

function load_app_version() {
    local version="1.0.0"
    local version_file="/usr/local/osconfig/os/bin/release_version.properties"
    [[ -f "${version_file}" ]] && version=$(grep "release_version"  "${version_file}" | awk -F'=' '{print $2}'| xargs)
    [[ -z "${version}" ]] && version="1.0.0"
    echo "" >> /usr/local/osconfig/os/lbin/env_profile.sh
    echo "export APP_VERSION=${version}" >> /usr/local/osconfig/os/lbin/env_profile.sh
}

function handle_osconfig_agent() 
{
    PRINT_LOG "INFO" "Handle osconfig agent..."
    cd /usr/local/osconfig/os/
    chmod 640 /usr/local/osconfig/os/lbin/env_profile.sh
    load_app_version
    chmod 550 /usr/local/osconfig/os/lbin/env_profile.sh
    chmod 500 /usr/local/osconfig/os/lbin
    chmod 700 /usr/local/osconfig/os/etc/manifest
    chmod 400 /usr/local/osconfig/os/etc/manifest/*

    PRINT_LOG "INFO" "Restart osconfig server..."
    local ret=1
    for i in {1..5}
    do
        PRINT_LOG "INFO" "Try $i time, Exec <bash osconfigserver.sh restart>..."  &> /dev/null
        bash /usr/local/osconfig/os/bin/osconfigserver.sh restart &> "${TMP_CONTENT_FILE}" || continue
        PRINT_LOG "INFO" "Register the osconfig service..."  &> /dev/null
        sleep 30
        ps -ef |grep -v grep | grep -q osconfigserver || continue
        register_system_service || continue
        add_cron || continue
        ret=0
        break
    done

    if [[ $ret -ne 0 ]]
    then
        PRINT_LOG "FATAL" "start osconfig server failure"
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        return 1
    fi
    PRINT_LOG "INFO" "Restart osconfig server done"
    PRINT_LOG "INFO" "Handle osconfig agent done"
    cd - &> /dev/null
    return 0
}

function register_system_service()
{
    PRINT_LOG "INFO" "Register osconfig system service..."
    . /usr/local/osconfig/os/lbin/env_profile.sh
    local python_file="/usr/local/osconfig/os/pyscripts/action/config_osconfig_service.py"
    if [[ ! -f "${python_file}" ]]
    then
        python_file="/usr/local/osconfig/os/pyscripts/action/config_osconfig_service.pyc"
    fi

    PRINT_LOG "INFO" "Invoke ${python_file}..."
    ${PYTHONHOME}/bin/python ${python_file} register
    if [[ $? -ne 0 ]]
    then
        PRINT_LOG "FATAL" "register osconfig system service failure"
        return 1
    fi
    
    PRINT_LOG "INFO" "Register osconfig system service done"
    return 0
}

# config cron to pretect osconfig service
function add_cron()
{
    PRINT_LOG "INFO" "config osconfig cron ..."
    . /usr/local/osconfig/os/lbin/env_profile.sh
    local python_file="/usr/local/osconfig/os/pyscripts/action/cron_action.pyc"
    if [[ ! -f "${python_file}" ]]
    then
        python_file="/usr/local/osconfig/os/pyscripts/action/cron_action.py"
    fi

    PRINT_LOG "INFO" "Invoke ${python_file}..."
    ${PYTHONHOME}/bin/python ${python_file} -action add
    if [[ $? -ne 0 ]]
    then
        PRINT_LOG "FATAL" "config osconfig cron  failure"
        return 1
    fi
    
    PRINT_LOG "INFO" "config osconfig cron done"
    return 0
}

function fn_invoke_file_perm() {
    local file_list="$1"
    local tmp_perm="$2"
    local type="$3"
    
    for suffix in ${file_list}
    do
        if [ "${type}" = "file" ]
        then
            find /usr/local/osconfig -name "${suffix}" -exec chmod "${tmp_perm}" {} + &>/dev/null
        else
            find /usr/local/osconfig -name "*.${suffix}" -exec chmod "${tmp_perm}" {} + &>/dev/null
        fi
    done
    return 0
}

function fn_chmod_file()
{
    local file_list="$1"
    local file_perm="$2"
    for suffix in ${file_list}
    do
        chmod "${file_perm}" "${suffix}"
    done
    return 0
}


function fn_install_pkg()
{
    local tmp_pkg_list="$1"
    local instal_path="$2"

    for tmp_pkg in ${tmp_pkg_list}
    do
        [ -z "${tmp_pkg}" ] && continue
        local pkgfile=$(echo ${tmp_pkg} | sed s#.cms##g)
        local pkgname=$(basename ${pkgfile})
        [[ "${instal_path}" =~ ^/usr/local/osconfig/*$ && "${pkgfile}" =~ ^custom- ]] && { unzip -v "${pkgfile}" | egrep -q '\s+os/\s*$' || continue; }
        [[ "${pkgfile}" = "sudobin_binary.zip" ]] && continue
        PRINT_LOG "INFO" "Start to install <${pkgname}> package..."
        [ "${pkgfile}" = "framework.zip" ] && exclude_file="-x os/bin/getntpinfo.sh os/bin/checkntpstatus.sh"

        unzip -o ${pkgfile} ${exclude_file} -d "${instal_path}" &> ${TMP_CONTENT_FILE}
        if [ $? -ne 0 ]
        then
            PRINT_LOG "FATAL" "Excute the command <unzip -o ${pkgfile} -d ${instal_path}> failure."
            PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
            return 1
        fi
        PRINT_LOG "INFO" "Install <${pkgname}> package done"
        exclude_file=''
    done

    return 0
}


function fn_install_custom()
{
    local os_type="$1"
    local tmp_arr=(${os_type//-/ })

    #Note: get os type
    local tmp_ostype=''
    local tmp_r_ver=''
    tmp_ostype="${tmp_arr[0]}"
    if [[ "${tmp_arr[0]}" =~ SuSE ]]
    then
        tmp_ostype="SuSE"
        tmp_r_ver="${tmp_arr[0]//SuSE/}"
    fi
    #Note: get os Rversion
    [ -z "${tmp_r_ver}" ] && tmp_r_ver="${tmp_arr[1]//SP*}"
    param_list="${tmp_ostype}${tmp_r_ver}|${tmp_ostype}-${tmp_r_ver}"

    local default_list=$(cd ${ABSOLUATELY_PATH}; ls custom-*-default.zip.cms 2> /dev/null | egrep "${param_list}" | xargs)
    for custom_name in ${default_list}
    do
        get_ver_list=$(ls /usr/local/osconfig/os | egrep "${param_list}"  | xargs)
        for ver_name in ${get_ver_list}
        do
            custom_list=$(ls ${ABSOLUATELY_PATH}/custom-*-${ver_name}.zip.cms 2> /dev/null)
            fn_install_pkg "${ABSOLUATELY_PATH}/${custom_name} ${custom_list}" "/usr/local/osconfig/os/${ver_name}" || return $?
        done
    done

    return 0
}


function fn_import_policy()
{
    PRINT_LOG "INFO" "Prepare to import rules and summary files."
    source /usr/local/osconfig/os/lbin/env_profile.sh
    local tmp_content=$(/usr/local/osconfig/os/bin/ostoolcli -module kernel -action is_support -type ima)
    [[ "${tmp_content}" =~ '"errorMessage":"","returnCode":0' ]] || { PRINT_LOG "INFO" "The current environment does not meet the IMA file import requirements, detail: ${tmp_content}";  return 0; }
    tmp_content=$(/usr/local/osconfig/os/bin/ostoolcli -module kernel -action import_policy -type ima)
    [[ "${tmp_content}" =~ '"errorMessage":"","returnCode":0' ]] && { PRINT_LOG "INFO" "The rule file is imported successfully."; return 0; } 
    PRINT_LOG "FATAL" "Failed to import rules and summary files, ${tmp_content}"
    return 1
}

function copy_sudobin_binary_pkg()
{
    PRINT_LOG "INFO" "Start to copy sudobin_binary.zip"
    [ ! -d "/usr/local/osconfig/os" ] && return 0
    [ ! -f "${ABSOLUATELY_PATH}/sudobin_binary.zip" ] && return 0

    for folder in `ls -d /usr/local/osconfig/os/* | xargs`
    do
        [ ! -f "${folder}/sudobin_pkg.tar" ] && continue
        cp -af ${ABSOLUATELY_PATH}/sudobin_binary.zip "${folder}" &> /dev/null
        cp -af ${ABSOLUATELY_PATH}/sudobin_binary.zip.cms "${folder}" &> /dev/null
        cp -af ${ABSOLUATELY_PATH}/sudobin_binary.zip.crl "${folder}" &> /dev/null
        chmod 400 "${folder}/sudobin_binary.zip" "${folder}/sudobin_binary.zip.cms" "${folder}/sudobin_binary.zip.crl" &> /dev/null
    done
    PRINT_LOG "INFO" "Copy sudobin_binary.zip done."
}

function fn_main()
{
    PRINT_LOG "INFO" "Start to install osconfig package."

    [ -f "${ABSOLUATELY_PATH}/common.inc" ] && chmod 400 ${ABSOLUATELY_PATH}/common.inc  &> /dev/null

    #Note:get parameter
    local param_num=$#
    local i
    local sudobinpath
    local install_force
    
    for((i=1; i<=param_num; i++))
    do
        [[ "${1}" == "-sudobinpath" ]] && { sudobinpath=${2}; shift 2; continue; }
        [[ "${1}" == "-force" ]] && { install_force=True; shift 2; continue; }
    done
    
    if [ -z "${sudobinpath}" -o ! -d "${sudobinpath}" ]
    then
        PRINT_LOG "FATAL" "Usage: bash install.sh -sudobinpath /usr/local/uniepsudobin [-force]"
        return 1
    fi

    local osconfig_cfg="/usr/local/osconfig/os/conf/common.cfg"
    local tmp_content=$(cd "/usr/local/osconfig" 2> /dev/null && ls -1 | grep -iv -e logs -e "etc")
    if [ ! -z "${tmp_content}" -o -e "/usr/local/osconfig/python" ]
    then
        local tmp_content=$( grep "^SUDOBIN_PATH=" "${osconfig_cfg}" 2> /dev/null)
        if [ ! -z "${tmp_content}" -a "${install_force}" != "True" ]
        then
            PRINT_LOG "FATAL" "The installation directory is not empty. Uninstall it before installation." 
            return 1
        fi
        
        PRINT_LOG "INFO" "Start to clear the old data of osconfig... "
        tmp_content=$(find /usr/local/osconfig | xargs -I {} stat -c "%A, %U:%G @@ access=%x, modify=%y,  change=%z %n" {} 2>&1)
        PRINT_LOG "INFO" "file list=${tmp_content}" &> /dev/null
        ls /usr/local/osconfig | grep -vw -e "logs" -e "etc" | xargs -I {} chmod -R 750 /usr/local/osconfig/{}
        ls /usr/local/osconfig | grep -vw -e "logs" -e "etc" | xargs -I {} rm -rf /usr/local/osconfig/{}
        if [ $? -ne 0 ]
        then
            PRINT_LOG "FATAL" "Exec< rm -rf /usr/local/osconfig/files> failure." 
            return 1
        fi

        if [ "${install_force}" = "True" -a -d "/usr/local/osconfig/etc" ]
        then
            PRINT_LOG "INFO" "Start to clear etc directory."
            rm -rf /usr/local/osconfig/etc &> /dev/null
        fi

        PRINT_LOG "INFO" "The osconfig old data is cleared. "
    fi
    
    #Note:install frame sudobin_pkg
    local sudopkg="${ABSOLUATELY_PATH}/sudobin_pkg.tar"
    local sudotmpPath="/tmp/osconfig_${RANDOM}_$$"

    sudo ${sudobinpath}/execute.sh "${sudopkg}" "${sudotmpPath}" "install.sh" "${sudobinpath}" &> "${TMP_CONTENT_FILE}"
    if [ $? -ne 0 ]
    then
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
        PRINT_LOG "FATAL" "Config framework sudo script failure."
        return 1
    fi
    PRINT_LOG "INFO" "Install framework sudo script done."
    cd ${ABSOLUATELY_PATH} &> /dev/null
    #Note:verify each install package
    local pkglst=$(ls ${ABSOLUATELY_PATH} | grep -w  ".*\.zip\.cms$" | xargs)
    for pkg in ${pkglst}
    do
        [ -z "${pkg}" ] && continue
        local pkgfile=$(echo ${pkg} | sed s#.cms##g)
        local pkg_cms_file="${ABSOLUATELY_PATH}/${pkg}"
        local pkg_file="${ABSOLUATELY_PATH}/${pkgfile}"
        local pkg_crl_file="${ABSOLUATELY_PATH}/${pkgfile}.crl"
        [ ! -f "${pkg_crl_file}" ] && pkg_crl_file=''

        sudo ${sudobinpath}/osconfiggpgcheck.sh "${pkg_cms_file}" "${pkg_file}" "${pkg_crl_file}" &> ${TMP_CONTENT_FILE}
        if [ $? -ne 0 ]
        then
            PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
            PRINT_LOG "FATAL" "The ${pkgfile} is invalid."
            fn_clean_sudo_script "${sudobinpath}"
            return 1
        fi
    done

    PRINT_LOG "INFO" "Check the install packages done."
    #Note:extract each package
    local custom_list=$(ls ${ABSOLUATELY_PATH} | grep -w  ".*\.zip\.cms$" | egrep  "^(default-|framework-)" | xargs)
    local pkg_list=$(ls ${ABSOLUATELY_PATH} | grep -w  ".*\.zip\.cms$" | egrep -v "default-|framework-|python|ostool-|default-binary-" | xargs)
    fn_install_pkg "${pkg_list} ${custom_list}" "/usr/local/osconfig" || return $?

    #Note:install the uninstall script
    cp -af ${ABSOLUATELY_PATH}/uninstall.sh /usr/local/osconfig/os/bin
    cp -af ${ABSOLUATELY_PATH}/uninstall_osconfig.sh /usr/local/osconfig/os/bin
    cp -af ${ABSOLUATELY_PATH}/sudobin_pkg.tar /usr/local/osconfig/os/bin
    copy_sudobin_binary_pkg

    [ -f ${ABSOLUATELY_PATH}/package/release_version.properties ] && cp -af ${ABSOLUATELY_PATH}/package/release_version.properties /usr/local/osconfig/os/bin

    #Note:get the os type
    local ostype=$(bash /usr/local/osconfig/os/bin/getostype.sh)
    if [ -z "${ostype}" ]
    then
        PRINT_LOG "FATAL" "Execute getostype.sh script failure."
        return 1
    fi

    fn_install_custom "${ostype}" || return $?
    #Note: install default binary package
    install_binary_tool ${ostype} || return $?

    chmod 640 /usr/local/osconfig/os/conf/common.cfg
    if `grep "INSTALL_OS_TYPE=" /usr/local/osconfig/os/conf/common.cfg`
    then
        sed -i "s#INSTALL_OS_TYPE=.*$#INSTALL_OS_TYPE=${ostype}#g" /usr/local/osconfig/os/conf/common.cfg
    else
        echo "" >> /usr/local/osconfig/os/conf/common.cfg
        echo "INSTALL_OS_TYPE=${ostype}" >> /usr/local/osconfig/os/conf/common.cfg
    fi

    if `grep "SUDOBIN_PATH=" /usr/local/osconfig/os/conf/common.cfg`
    then
        sed -i "s#SUDOBIN_PATH=.*$#SUDOBIN_PATH=${sudobinpath}#g" /usr/local/osconfig/os/conf/common.cfg
    else
        echo "" >> /usr/local/osconfig/os/conf/common.cfg
        echo "SUDOBIN_PATH=${sudobinpath}" >> /usr/local/osconfig/os/conf/common.cfg
    fi

    #Note: get the python pkg
    PRINT_LOG "INFO" "Start to install the python..."
    fn_get_python_pkg "${ostype}" "pythonPkg" || return $?
    if [ ! -f "${pythonPkg}" ]
    then
        PRINT_LOG "FATAL" "The python install package <${pythonPkg}> does not exist."
        return 1
    fi

    local ret
    PRINT_LOG "INFO" "The os type is ${ostype}" &> /dev/null
    bash /usr/local/osconfig/os/${ostype}/install.sh "${sudobinpath}" "${ABSOLUATELY_PATH}" &> ${TMP_CONTENT_FILE}
    if [ $? -ne 0 ]
    then
        PRINT_LOG "FATAL" "Excute the command <bash /usr/local/osconfig/os/{ostype}/install.sh> failure."
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
        return 1
    fi

    fn_install_os_tool "${sudobinpath}" "${ostype}" || return $?

    fn_clean_sudo_script "${sudobinpath}"
    unzip -o framework.zip os/bin/getntpinfo.sh os/bin/checkntpstatus.sh -d /usr/local/osconfig &> ${TMP_CONTENT_FILE}
    if [ $? -ne 0 ]
    then
        PRINT_LOG "FATAL" "Excute the command <unzip -o framework.zip os/bin/getntpinfo.sh os/bin/checkntpstatus.sh -d /usr/local/osconfig> failure."
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
        return 1
    fi

    #Note: change the permission
    find /usr/local/osconfig -type d ! -name "logs" -exec chmod 550 {} + &> /dev/null
    find /usr/local/osconfig -type f -exec chmod 550 {} + &> /dev/null
    find /usr/local/osconfig/os/pyscripts -type f -exec chmod 440 {} + &> /dev/null
    find /usr/local/osconfig -type f -name "*.tar" -exec chmod 400 {} + &> /dev/null
    chmod -R 750 /usr/local/osconfig/os/python-* &> /dev/null

    fn_invoke_file_perm "libstdc++.so.6" "440" "file"
    fn_invoke_file_perm "sh" "500"
    fn_invoke_file_perm "getostype.sh" "550" "file"
    fn_invoke_file_perm "bin" "550" "file"

    find /usr/local/osconfig/os/bin -name "*.sh" -exec chmod 550 {} + &>/dev/null
    find /usr/local/osconfig/logs -type d -exec chmod 750 {} + &>/dev/null
    find /usr/local/osconfig/logs/ -type f -exec chmod 640 {} + &> /dev/null
    find /usr/local/osconfig/logs/ -name "*.zip" -exec chmod 440 {} + &>/dev/null
    find /usr/local/osconfig/logs/ -name "*.gz" -exec chmod 440 {} + &>/dev/null
    chmod 750 /usr/local/osconfig /usr/local/osconfig/os &> /dev/null
    chmod 700 /usr/local/osconfig/os/cipher &> /dev/null
    local file_suffix="/usr/local/osconfig/os/bin/uninstall.sh /usr/local/osconfig/os/bin/gettimezonelist.sh /usr/local/osconfig/os/bin/osprofile"
    fn_chmod_file "${file_suffix}" "550"

    #Note:link the python path
    local pythonName=$(basename ${pythonPkg})
    local pyInstallPath=$(echo ${pythonName} | sed -e s#.zip##g)
    unzip -o ${pythonPkg} -d /usr/local/osconfig/${pyInstallPath} &> ${TMP_CONTENT_FILE}
    if [ $? -ne 0 ]
    then
        PRINT_LOG "FATAL" "Excute the command <unzip -o ${pythonPkg} -d /usr/local/osconfig/${pyInstallPath}> failure."
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
        return 1
    fi

    [ -L "/usr/local/osconfig/python" ] && rm -f /usr/local/osconfig/python
    ln -s /usr/local/osconfig/${pyInstallPath} /usr/local/osconfig/python

    PRINT_LOG "INFO" "Create link for python home done."

    local file_suffix="cfg txt def icns tmpl json properties yaml"
    fn_invoke_file_perm "${file_suffix}" "640"

    local file_suffix="inc html gif icns ico png css"
    fn_invoke_file_perm "${file_suffix}" "440"

    local file_suffix="csh a o"
    fn_invoke_file_perm "${file_suffix}" "550"

    local file_suffix="zip crl cms"
    fn_invoke_file_perm "${file_suffix}" "400"
    
    local file_suffix="installagent osconfigserver uninstall_osconfig.sh getsupportntptype_sub.sh"
    fn_invoke_file_perm "${file_suffix}" "500" "file"
    
    find /usr/local/osconfig/python/ -type d -exec chmod 550 {} + &> /dev/null
    find /usr/local/osconfig/python/ -type f -exec chmod 440 {} + &>/dev/null
    find /usr/local/osconfig/python/bin/ -type f -exec chmod 550 {} + &> /dev/null
    find /usr/local/osconfig/python/ -type f -name "*.pem" -exec chmod 600 {} + > /dev/null 2>&1
    find /usr/local/osconfig/python/ -type d -name "certifi" -exec chmod 700 {} + > /dev/null 2>&1
    local certifi_dir=$(find /usr/local/osconfig/python/  -type d -name certifi | head -1)
    [ -z "${certifi_dir}" ] || rm -rf "${certifi_dir}" 2> /dev/null
    PRINT_LOG "INFO" "Install the python done"

    # change the permission for etc and encrypt and conf
    find /usr/local/osconfig/etc -type d -exec chmod 750 {} + &> /dev/null
    find /usr/local/osconfig/etc -type f -exec chmod 600 {} + &> /dev/null
    find /usr/local/osconfig/os -type f -name encrypt.py* -exec chmod 400 {} + &> /dev/null
    chmod 500 /usr/local/osconfig/os/bin/healthcheck &> /dev/null
    chmod 750 /usr/local/osconfig/os/conf /usr/local/osconfig/os/default/conf
    ps -ef | grep -v grep | grep updatetimezoneinfo &> /dev/null
    local ret=$?
    update_timezone="/usr/local/osconfig/os/bin/updatetimezoneinfo.sh"
    if [ -f "${update_timezone}" -a "${ret}" -ne 0 ]
    then
        PRINT_LOG "INFO" "Exec<bash ${update_timezone}>..."
        bash "${update_timezone}" &> /dev/null &
    fi

    handle_osconfig_agent "${ostype}"
    if [[ $? -ne 0 ]]
       then
        PRINT_LOG "FATAL" "failed to handle osconfig agent."
        return 1
    fi

    fn_import_policy || return $?

    PRINT_LOG "INFO" "Invoke config_harden.sh ..."
    bash /usr/local/osconfig/os/bin/config_harden.sh &> /dev/null
    if [ $? -ne 0 ]
    then
        PRINT_LOG "FATAL" "Execute the config_harden.sh config sshd service failure."
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
        return 1
    fi
    
    PRINT_LOG "INFO" "Install osconfig package done."
    return 0
}

fn_main "$@"
RET_MAIN=$?
if [[ "$RET_MAIN" == "0" ]]
then
    logger -t $USER -p local0.info "$FileName;Successful;${OPERIP:-127.0.0.1};Excute execution $FileName to install osconfig."
else
    logger -t $USER -p local0.err "$FileName;Failed;${OPERIP:-127.0.0.1};Excute execution $FileName to install osconfig."
fi

[ -d "${LOGPATH}" -a -f "${CONSTANT_LOGFILE}" ] && cp -af "${CONSTANT_LOGFILE}" "/usr/local/osconfig/logs/" 2> /dev/null
[ -f "${TMP_CONTENT_FILE}" ] && rm -f "${TMP_CONTENT_FILE}" &> /dev/null
FUNC_CLEAN_TMP_FILE &> /dev/null
exit ${RET_MAIN}
