/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class DateCache {
    private Map<String, Date> cache = new HashMap<String, Date>();

    public void populate(String datePattern, int fromYear, int toYear) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        for (int year = fromYear; year <= toYear; ++year) {
            for (int day = 0; day <= 367; ++day) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, year);
                calendar.set(6, day);
                if (calendar.get(1) != year) continue;
                String dateString = dateFormat.format(calendar.getTime());
                this.cache.put(dateString, calendar.getTime());
            }
        }
    }

    public void addDate(String dateString, Date date) {
        this.cache.put(dateString, date);
    }

    public Date lookupDate(String dateString) {
        return this.cache.get(dateString);
    }

    public int getSize() {
        return this.cache.size();
    }

    public static void main(String[] args) throws ParseException {
        String dateFormatString = "yyyy/MM/dd";
        int startYear = 1890;
        int endYear = 2012;
        long start = System.currentTimeMillis();
        DateCache dateCache = new DateCache();
        dateCache.populate("yyyy/MM/dd", 1895, 2012);
        long end = System.currentTimeMillis();
        System.out.println("Creating cache of " + dateCache.getSize() + " dates : " + (end - start) + " ms");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        int size = 10000000;
        ArrayList<String> randomDates = new ArrayList<String>(10000000);
        for (int i = 0; i < 10000000; ++i) {
            Calendar cal = Calendar.getInstance();
            int rndYear = 1890 + (int)Math.round(Math.random() * 122.0);
            int rndDay = (int)Math.round(Math.random() * 365.0);
            cal.set(1, rndYear);
            cal.set(6, rndDay);
            String dateString = dateFormat.format(cal.getTime());
            randomDates.add(dateString);
        }
        start = System.currentTimeMillis();
        for (String randomDate : randomDates) {
            dateFormat.parse(randomDate);
        }
        end = System.currentTimeMillis();
        System.out.println("Parsing 10000000 dates : " + (end - start) + " ms");
        int retries = 0;
        start = System.currentTimeMillis();
        for (String randomDate : randomDates) {
            Date date = dateCache.lookupDate(randomDate);
            if (date != null) continue;
            dateFormat.parse(randomDate);
            ++retries;
        }
        end = System.currentTimeMillis();
        System.out.println("Looking up 10000000 dates : " + (end - start) + " ms  (" + retries + " retries)");
        dateCache = new DateCache();
        retries = 0;
        start = System.currentTimeMillis();
        for (String randomDate : randomDates) {
            Date date = dateCache.lookupDate(randomDate);
            if (date != null) continue;
            date = dateFormat.parse(randomDate);
            dateCache.addDate(randomDate, date);
            ++retries;
        }
        end = System.currentTimeMillis();
        System.out.println("Looking up 10000000 dates with incremental cache population: " + (end - start) + " ms  (" + retries + " misses)");
    }
}

