/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLogLayout;
import org.pentaho.di.core.logging.KettleLoggingEvent;

public class LogChannelFileWriterBuffer {
    private KettleLogLayout layout;
    private String logChannelId;
    private final List<KettleLoggingEvent> buffer = Collections.synchronizedList(new LinkedList());

    public LogChannelFileWriterBuffer(String logChannelId) {
        this.logChannelId = logChannelId;
        this.layout = new KettleLogLayout(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(KettleLoggingEvent event) {
        List<KettleLoggingEvent> list = this.buffer;
        synchronized (list) {
            this.buffer.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getBuffer() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        List<KettleLoggingEvent> list = this.buffer;
        synchronized (list) {
            for (KettleLoggingEvent event : this.buffer) {
                stringBuffer.append(this.layout.format(event)).append(Const.CR);
            }
            this.buffer.clear();
        }
        return stringBuffer;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }
}

