/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row.value;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.core.plugins.IValueMetaConverter;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaConversionException;

public class ValueMetaConverter
implements Serializable,
IValueMetaConverter {
    private SimpleDateFormat datePattern = new SimpleDateFormat(ValueMetaBase.DEFAULT_DATE_FORMAT_MASK);
    private int precision = 0;

    public SimpleDateFormat getDatePattern() {
        return this.datePattern;
    }

    @Override
    public void setDatePattern(SimpleDateFormat datePattern) {
        if (datePattern != null) {
            this.datePattern = datePattern;
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public Object convertFromSourceToTargetDataType(int sourceValueMetaType, int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        switch (sourceValueMetaType) {
            case 10: {
                return this.convertFromInetMetaInterface(targetValueMetaType, value);
            }
            case 2: {
                return this.convertFromStringMetaInterface(targetValueMetaType, value);
            }
            case 5: {
                return this.convertFromIntegerMetaInterface(targetValueMetaType, value);
            }
            case 1: {
                return this.convertFromNumberMetaInterface(targetValueMetaType, value);
            }
            case 6: {
                return this.convertFromBigNumberMetaInterface(targetValueMetaType, value);
            }
            case 9: {
                return this.convertFromTimestampMetaInterface(targetValueMetaType, value);
            }
            case 3: {
                return this.convertFromDateMetaInterface(targetValueMetaType, value);
            }
            case 4: {
                return this.convertFromBooleanMetaInterface(targetValueMetaType, value);
            }
            case 8: {
                return this.convertFromBinaryMetaInterface(targetValueMetaType, value);
            }
            case 7: {
                return this.convertFromSerializableMetaInterface(targetValueMetaType, value);
            }
        }
        this.throwBadConversionCombination(sourceValueMetaType, targetValueMetaType, value);
        return null;
    }

    protected Object convertFromStringMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            this.handleConversionError("Error.  Expecting value of type string.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        String stringValue = (String)value;
        try {
            switch (targetValueMetaType) {
                case 10: {
                    try {
                        return InetAddress.getByName(value.toString());
                    }
                    catch (UnknownHostException e) {
                        return null;
                    }
                }
                case 2: {
                    return new String(stringValue);
                }
                case 5: {
                    return Long.parseLong(this.stripDecimal(stringValue));
                }
                case 1: {
                    Double doubleValue = Double.parseDouble(stringValue);
                    if (this.getPrecision() > 0) {
                        BigDecimal bigDecimal = new BigDecimal(doubleValue);
                        bigDecimal = bigDecimal.setScale(this.getPrecision(), RoundingMode.HALF_UP);
                        doubleValue = bigDecimal.doubleValue();
                    }
                    return doubleValue;
                }
                case 6: {
                    return new BigDecimal(stringValue);
                }
                case 9: {
                    return new Timestamp(this.datePattern.parse(stringValue).getTime());
                }
                case 3: {
                    return this.datePattern.parse(stringValue);
                }
                case 4: {
                    return Boolean.parseBoolean(stringValue);
                }
                case 8: {
                    return stringValue.getBytes();
                }
            }
            this.throwBadConversionCombination(2, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(2, targetValueMetaType, value, e);
        }
        return null;
    }

    protected Object convertFromDateMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Date)) {
            this.handleConversionError("Error.  Expecting value of type Date.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            Date dateValue = (Date)value;
            switch (targetValueMetaType) {
                case 5: {
                    return dateValue.getTime();
                }
                case 2: {
                    return this.datePattern.format(dateValue);
                }
                case 9: {
                    return new Timestamp(dateValue.getTime());
                }
                case 3: {
                    return new Date(dateValue.getTime());
                }
            }
            this.throwBadConversionCombination(3, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(3, targetValueMetaType, value, e);
        }
        return null;
    }

    protected Object convertFromNumberMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Double)) {
            this.handleConversionError("Error.  Expecting value of type Double.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaType) {
                case 2: {
                    return Double.toString((Double)value);
                }
                case 1: {
                    Double doubleValue = new Double((Double)value);
                    if (this.getPrecision() > 0) {
                        BigDecimal bigDecimal = new BigDecimal(doubleValue);
                        bigDecimal = bigDecimal.setScale(this.getPrecision(), RoundingMode.HALF_UP);
                        doubleValue = bigDecimal.doubleValue();
                    }
                    return doubleValue;
                }
                case 5: {
                    return ((Double)value).longValue();
                }
                case 6: {
                    return new BigDecimal((Double)value);
                }
            }
            this.throwBadConversionCombination(1, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(1, targetValueMetaType, value, e);
        }
        return null;
    }

    protected Object convertFromBooleanMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Boolean)) {
            this.handleConversionError("Error.  Expecting value of type Boolean.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaType) {
                case 2: {
                    return Boolean.toString((Boolean)value);
                }
                case 4: {
                    return new Boolean((Boolean)value);
                }
            }
            this.throwBadConversionCombination(4, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(4, targetValueMetaType, value, e);
        }
        return null;
    }

    protected Object convertFromIntegerMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return value;
        }
        if (!(value instanceof Long)) {
            this.handleConversionError("Error.  Expecting value of type Long.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaType) {
                case 2: {
                    return Long.toString((Long)value);
                }
                case 5: {
                    return new Long((Long)value);
                }
                case 1: {
                    Double doubleValue = ((Long)value).doubleValue();
                    if (this.getPrecision() > 0) {
                        BigDecimal bigDecimal = new BigDecimal(doubleValue);
                        bigDecimal = bigDecimal.setScale(this.getPrecision(), RoundingMode.HALF_UP);
                        doubleValue = bigDecimal.doubleValue();
                    }
                    return doubleValue;
                }
                case 6: {
                    return new BigDecimal(((Long)value).doubleValue());
                }
                case 3: {
                    return new Date((Long)value);
                }
                case 9: {
                    return new Timestamp((Long)value);
                }
            }
            this.throwBadConversionCombination(5, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(5, targetValueMetaType, value, e);
        }
        return value;
    }

    protected Object convertFromBigNumberMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof BigDecimal)) {
            this.handleConversionError("Error.  Expecting value of type BigNumber(BigDecimal).    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaType) {
                case 2: {
                    return value.toString();
                }
                case 1: {
                    Double doubleValue = ((BigDecimal)value).doubleValue();
                    if (this.getPrecision() > 0) {
                        BigDecimal bigDecimal = new BigDecimal(doubleValue);
                        bigDecimal = bigDecimal.setScale(this.getPrecision(), RoundingMode.HALF_UP);
                        doubleValue = bigDecimal.doubleValue();
                    }
                    return doubleValue;
                }
                case 6: {
                    return new BigDecimal(((BigDecimal)value).toString());
                }
            }
            this.throwBadConversionCombination(6, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(6, targetValueMetaType, value, e);
        }
        return value;
    }

    protected Object convertFromTimestampMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Timestamp)) {
            this.handleConversionError("Error.  Expecting value of type Timestamp.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaType) {
                case 2: {
                    Date dateValue = new Date(((Timestamp)value).getTime());
                    return this.datePattern.format(dateValue);
                }
                case 5: {
                    return ((Timestamp)value).getTime();
                }
                case 9: {
                    return new Timestamp(((Timestamp)value).getTime());
                }
                case 3: {
                    return new Date(((Timestamp)value).getTime());
                }
            }
            this.throwBadConversionCombination(9, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(9, targetValueMetaType, value, e);
        }
        return value;
    }

    protected Object convertFromInetMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof InetAddress)) {
            this.handleConversionError("Error.  Expecting value of type InetAddress.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        InetAddress origInetAddress = (InetAddress)value;
        try {
            switch (targetValueMetaType) {
                case 10: {
                    try {
                        return InetAddress.getByName(origInetAddress.getHostAddress());
                    }
                    catch (UnknownHostException e) {
                        return null;
                    }
                }
                case 2: {
                    return origInetAddress.getHostAddress();
                }
            }
            this.throwBadConversionCombination(10, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(10, targetValueMetaType, value, e);
        }
        return null;
    }

    protected Object convertFromBinaryMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof ByteBuffer) && !(value instanceof byte[])) {
            this.handleConversionError("Error.  Expecting value of type ByteBuffer.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaType) {
                case 8: {
                    if (value instanceof byte[]) {
                        return value;
                    }
                    return ((ByteBuffer)value).array();
                }
            }
            this.throwBadConversionCombination(8, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(8, targetValueMetaType, value, e);
        }
        return null;
    }

    protected Object convertFromSerializableMetaInterface(int targetValueMetaType, Object value) throws ValueMetaConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Serializable)) {
            this.handleConversionError("Error.  Expecting value of type Serializable.    actual value type = '" + value.getClass() + "'.    value = '" + value + "'.");
        }
        try {
            switch (targetValueMetaType) {
                case 7: {
                    return value;
                }
            }
            this.throwBadConversionCombination(7, targetValueMetaType, value);
        }
        catch (Exception e) {
            this.throwErroredConversion(7, targetValueMetaType, value, e);
        }
        return null;
    }

    private void throwBadConversionCombination(int sourceValueMetaType, int targetValueMetaType, Object sourceValue) throws ValueMetaConversionException {
        this.handleConversionError("Error.  Can not convert from " + ValueMetaInterface.getTypeDescription(sourceValueMetaType) + " to " + ValueMetaInterface.getTypeDescription(targetValueMetaType) + ".  Actual value type = '" + sourceValue.getClass() + "'.    value = '" + sourceValue + "'.");
    }

    private void throwErroredConversion(int sourceValueMetaType, int targetValueMetaType, Object sourceValue, Exception e) throws ValueMetaConversionException {
        this.handleConversionError("Error trying to convert from " + ValueMetaInterface.getTypeDescription(sourceValueMetaType) + " to " + ValueMetaInterface.getTypeDescription(targetValueMetaType) + ".  value = '" + sourceValue + "'.  Error:  " + e.getClass() + ":  " + e.getMessage(), e);
    }

    private void handleConversionError(String errorMessage) throws ValueMetaConversionException {
        this.handleConversionError(errorMessage, null);
    }

    private void handleConversionError(String errorMessage, Exception e) throws ValueMetaConversionException {
        throw new ValueMetaConversionException(errorMessage, e);
    }

    private String stripDecimal(String s) {
        int decimalPosition = s.indexOf(46);
        return decimalPosition != -1 ? s.substring(0, decimalPosition) : s;
    }
}

