/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.IRepositoryImporter;
import org.pentaho.di.repository.IRepositoryService;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;

public interface Repository {
    public String getName();

    public String getVersion();

    public RepositoryMeta getRepositoryMeta();

    public IUser getUserInfo();

    public RepositorySecurityProvider getSecurityProvider();

    public RepositorySecurityManager getSecurityManager();

    public LogChannelInterface getLog();

    public void connect(String var1, String var2) throws KettleException, KettleSecurityException;

    public void disconnect();

    public boolean isConnected();

    default public Optional<URI> getUri() {
        return Optional.empty();
    }

    public void init(RepositoryMeta var1);

    public boolean exists(String var1, RepositoryDirectoryInterface var2, RepositoryObjectType var3) throws KettleException;

    public ObjectId getTransformationID(String var1, RepositoryDirectoryInterface var2) throws KettleException;

    public ObjectId getJobId(String var1, RepositoryDirectoryInterface var2) throws KettleException;

    public void save(RepositoryElementInterface var1, String var2, ProgressMonitorListener var3) throws KettleException;

    public void save(RepositoryElementInterface var1, String var2, ProgressMonitorListener var3, boolean var4) throws KettleException;

    public void save(RepositoryElementInterface var1, String var2, Calendar var3, ProgressMonitorListener var4, boolean var5) throws KettleException;

    public RepositoryDirectoryInterface getDefaultSaveDirectory(RepositoryElementInterface var1) throws KettleException;

    public RepositoryDirectoryInterface getUserHomeDirectory() throws KettleException;

    public void clearSharedObjectCache();

    public TransMeta loadTransformation(String var1, RepositoryDirectoryInterface var2, ProgressMonitorListener var3, boolean var4, String var5) throws KettleException;

    public TransMeta loadTransformation(ObjectId var1, String var2) throws KettleException;

    public SharedObjects readTransSharedObjects(TransMeta var1) throws KettleException;

    public ObjectId renameTransformation(ObjectId var1, RepositoryDirectoryInterface var2, String var3) throws KettleException;

    public ObjectId renameTransformation(ObjectId var1, String var2, RepositoryDirectoryInterface var3, String var4) throws KettleException;

    public void deleteTransformation(ObjectId var1) throws KettleException;

    public JobMeta loadJob(String var1, RepositoryDirectoryInterface var2, ProgressMonitorListener var3, String var4) throws KettleException;

    public JobMeta loadJob(ObjectId var1, String var2) throws KettleException;

    public SharedObjects readJobMetaSharedObjects(JobMeta var1) throws KettleException;

    public ObjectId renameJob(ObjectId var1, String var2, RepositoryDirectoryInterface var3, String var4) throws KettleException;

    public ObjectId renameJob(ObjectId var1, RepositoryDirectoryInterface var2, String var3) throws KettleException;

    public void deleteJob(ObjectId var1) throws KettleException;

    public DatabaseMeta loadDatabaseMeta(ObjectId var1, String var2) throws KettleException;

    public void deleteDatabaseMeta(String var1) throws KettleException;

    public ObjectId[] getDatabaseIDs(boolean var1) throws KettleException;

    public String[] getDatabaseNames(boolean var1) throws KettleException;

    public List<DatabaseMeta> readDatabases() throws KettleException;

    public ObjectId getDatabaseID(String var1) throws KettleException;

    public ClusterSchema loadClusterSchema(ObjectId var1, List<SlaveServer> var2, String var3) throws KettleException;

    public ObjectId[] getClusterIDs(boolean var1) throws KettleException;

    public String[] getClusterNames(boolean var1) throws KettleException;

    public ObjectId getClusterID(String var1) throws KettleException;

    public void deleteClusterSchema(ObjectId var1) throws KettleException;

    public SlaveServer loadSlaveServer(ObjectId var1, String var2) throws KettleException;

    public ObjectId[] getSlaveIDs(boolean var1) throws KettleException;

    public String[] getSlaveNames(boolean var1) throws KettleException;

    public List<SlaveServer> getSlaveServers() throws KettleException;

    public ObjectId getSlaveID(String var1) throws KettleException;

    public void deleteSlave(ObjectId var1) throws KettleException;

    public PartitionSchema loadPartitionSchema(ObjectId var1, String var2) throws KettleException;

    public ObjectId[] getPartitionSchemaIDs(boolean var1) throws KettleException;

    public String[] getPartitionSchemaNames(boolean var1) throws KettleException;

    public ObjectId getPartitionSchemaID(String var1) throws KettleException;

    public void deletePartitionSchema(ObjectId var1) throws KettleException;

    public RepositoryDirectoryInterface loadRepositoryDirectoryTree() throws KettleException;

    public RepositoryDirectoryInterface findDirectory(String var1) throws KettleException;

    public RepositoryDirectoryInterface findDirectory(ObjectId var1) throws KettleException;

    public void saveRepositoryDirectory(RepositoryDirectoryInterface var1) throws KettleException;

    public void deleteRepositoryDirectory(RepositoryDirectoryInterface var1) throws KettleException;

    public ObjectId renameRepositoryDirectory(ObjectId var1, RepositoryDirectoryInterface var2, String var3) throws KettleException;

    public RepositoryDirectoryInterface createRepositoryDirectory(RepositoryDirectoryInterface var1, String var2) throws KettleException;

    public String[] getTransformationNames(ObjectId var1, boolean var2) throws KettleException;

    public List<RepositoryElementMetaInterface> getJobObjects(ObjectId var1, boolean var2) throws KettleException;

    public List<RepositoryElementMetaInterface> getTransformationObjects(ObjectId var1, boolean var2) throws KettleException;

    public List<RepositoryElementMetaInterface> getJobAndTransformationObjects(ObjectId var1, boolean var2) throws KettleException;

    public String[] getJobNames(ObjectId var1, boolean var2) throws KettleException;

    public String[] getDirectoryNames(ObjectId var1) throws KettleException;

    public ObjectId insertLogEntry(String var1) throws KettleException;

    public void insertStepDatabase(ObjectId var1, ObjectId var2, ObjectId var3) throws KettleException;

    public void insertJobEntryDatabase(ObjectId var1, ObjectId var2, ObjectId var3) throws KettleException;

    public void saveConditionStepAttribute(ObjectId var1, ObjectId var2, String var3, Condition var4) throws KettleException;

    public Condition loadConditionFromStepAttribute(ObjectId var1, String var2) throws KettleException;

    public boolean getStepAttributeBoolean(ObjectId var1, int var2, String var3, boolean var4) throws KettleException;

    public boolean getStepAttributeBoolean(ObjectId var1, int var2, String var3) throws KettleException;

    public boolean getStepAttributeBoolean(ObjectId var1, String var2) throws KettleException;

    public long getStepAttributeInteger(ObjectId var1, int var2, String var3) throws KettleException;

    public long getStepAttributeInteger(ObjectId var1, String var2) throws KettleException;

    public String getStepAttributeString(ObjectId var1, int var2, String var3) throws KettleException;

    public String getStepAttributeString(ObjectId var1, String var2) throws KettleException;

    public void saveStepAttribute(ObjectId var1, ObjectId var2, int var3, String var4, String var5) throws KettleException;

    public void saveStepAttribute(ObjectId var1, ObjectId var2, String var3, String var4) throws KettleException;

    public void saveStepAttribute(ObjectId var1, ObjectId var2, int var3, String var4, boolean var5) throws KettleException;

    public void saveStepAttribute(ObjectId var1, ObjectId var2, String var3, boolean var4) throws KettleException;

    public void saveStepAttribute(ObjectId var1, ObjectId var2, int var3, String var4, long var5) throws KettleException;

    public void saveStepAttribute(ObjectId var1, ObjectId var2, String var3, long var4) throws KettleException;

    public void saveStepAttribute(ObjectId var1, ObjectId var2, int var3, String var4, double var5) throws KettleException;

    public void saveStepAttribute(ObjectId var1, ObjectId var2, String var3, double var4) throws KettleException;

    public int countNrStepAttributes(ObjectId var1, String var2) throws KettleException;

    public int countNrJobEntryAttributes(ObjectId var1, String var2) throws KettleException;

    public boolean getJobEntryAttributeBoolean(ObjectId var1, String var2) throws KettleException;

    public boolean getJobEntryAttributeBoolean(ObjectId var1, int var2, String var3) throws KettleException;

    public boolean getJobEntryAttributeBoolean(ObjectId var1, String var2, boolean var3) throws KettleException;

    public long getJobEntryAttributeInteger(ObjectId var1, String var2) throws KettleException;

    public long getJobEntryAttributeInteger(ObjectId var1, int var2, String var3) throws KettleException;

    public String getJobEntryAttributeString(ObjectId var1, String var2) throws KettleException;

    public String getJobEntryAttributeString(ObjectId var1, int var2, String var3) throws KettleException;

    public void saveJobEntryAttribute(ObjectId var1, ObjectId var2, int var3, String var4, String var5) throws KettleException;

    public void saveJobEntryAttribute(ObjectId var1, ObjectId var2, String var3, String var4) throws KettleException;

    public void saveJobEntryAttribute(ObjectId var1, ObjectId var2, int var3, String var4, boolean var5) throws KettleException;

    public void saveJobEntryAttribute(ObjectId var1, ObjectId var2, String var3, boolean var4) throws KettleException;

    public void saveJobEntryAttribute(ObjectId var1, ObjectId var2, int var3, String var4, long var5) throws KettleException;

    public void saveJobEntryAttribute(ObjectId var1, ObjectId var2, String var3, long var4) throws KettleException;

    public DatabaseMeta loadDatabaseMetaFromStepAttribute(ObjectId var1, String var2, List<DatabaseMeta> var3) throws KettleException;

    public void saveDatabaseMetaStepAttribute(ObjectId var1, ObjectId var2, String var3, DatabaseMeta var4) throws KettleException;

    public DatabaseMeta loadDatabaseMetaFromJobEntryAttribute(ObjectId var1, String var2, String var3, List<DatabaseMeta> var4) throws KettleException;

    public DatabaseMeta loadDatabaseMetaFromJobEntryAttribute(ObjectId var1, String var2, int var3, String var4, List<DatabaseMeta> var5) throws KettleException;

    public void saveDatabaseMetaJobEntryAttribute(ObjectId var1, ObjectId var2, String var3, String var4, DatabaseMeta var5) throws KettleException;

    public void saveDatabaseMetaJobEntryAttribute(ObjectId var1, ObjectId var2, int var3, String var4, String var5, DatabaseMeta var6) throws KettleException;

    public void undeleteObject(RepositoryElementMetaInterface var1) throws KettleException;

    public List<Class<? extends IRepositoryService>> getServiceInterfaces() throws KettleException;

    public IRepositoryService getService(Class<? extends IRepositoryService> var1) throws KettleException;

    public boolean hasService(Class<? extends IRepositoryService> var1) throws KettleException;

    public RepositoryObject getObjectInformation(ObjectId var1, RepositoryObjectType var2) throws KettleException;

    public String getConnectMessage();

    public String[] getJobsUsingDatabase(ObjectId var1) throws KettleException;

    public String[] getTransformationsUsingDatabase(ObjectId var1) throws KettleException;

    public IRepositoryImporter getImporter();

    public IRepositoryExporter getExporter() throws KettleException;

    public IMetaStore getMetaStore();

    public IUnifiedRepository getUnderlyingRepository();
}

