/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectory;

public class UserInfo
implements IUser {
    public static final String REPOSITORY_ELEMENT_TYPE = "user";
    private ObjectId id;
    private String login;
    private String password;
    private String username;
    private String description;
    private boolean enabled;
    private Boolean admin;

    public UserInfo(IUser copyFrom) {
        this.id = copyFrom.getObjectId();
        this.login = copyFrom.getLogin();
        this.password = copyFrom.getPassword();
        this.username = copyFrom.getUsername();
        this.description = copyFrom.getDescription();
        this.enabled = copyFrom.isEnabled();
        this.admin = copyFrom.isAdmin();
    }

    public UserInfo(String login, String password, String username, String description, boolean enabled) {
        this.login = login;
        this.password = password;
        this.username = username;
        this.description = description;
        this.enabled = enabled;
    }

    public UserInfo(String login) {
        this();
        this.login = login;
    }

    public UserInfo() {
        this.login = null;
        this.password = null;
        this.username = null;
        this.description = null;
        this.enabled = true;
        this.admin = null;
    }

    @Override
    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setEnabled() {
        this.setEnabled(true);
    }

    public void setDisabled() {
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public ObjectId getObjectId() {
        return this.id;
    }

    @Override
    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public RepositoryDirectory getRepositoryDirectory() {
        return new RepositoryDirectory();
    }

    public void setRepositoryDirectory(RepositoryDirectory repositoryDirectory) {
        throw new RuntimeException("Setting a directory on a database connection is not supported");
    }

    public String getRepositoryElementType() {
        return REPOSITORY_ELEMENT_TYPE;
    }

    @Override
    public String getName() {
        return this.login;
    }

    @Override
    public void setName(String name) {
        this.login = name;
    }

    @Override
    public Boolean isAdmin() {
        return this.admin;
    }

    @Override
    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }
}

