/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Rows;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.ael.websocket.MessageEventService;
import org.pentaho.di.trans.ael.websocket.Util;
import org.pentaho.di.trans.ael.websocket.exception.MessageEventHandlerExecutionException;
import org.pentaho.di.trans.ael.websocket.handler.MessageEventHandler;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepStatus;

public class StepInterfaceWebSocketEngineAdapter
extends BaseStep {
    private static final String ROWS_HANDLER_ID = "ROWS_STEP_INTERFACE_";
    private static final String METRICS_HANDLER_ID = "METRICS_STEP_INTERFACE_";
    private static final String OPERATION_STATUS_HANDLER_ID = "OPERATION_STATUS_STEP_INTERFACE_";
    private final Operation operation;
    private final MessageEventService messageEventService;
    private List<StepMetaDataCombi> subSteps;

    public StepInterfaceWebSocketEngineAdapter(Operation op, MessageEventService messageEventService, StepMeta stepMeta, TransMeta transMeta, StepDataInterface dataInterface, Trans trans, List<StepMetaDataCombi> subSteps) throws KettleException {
        super(stepMeta, dataInterface, 0, transMeta, trans);
        this.operation = op;
        this.messageEventService = messageEventService;
        this.subSteps = subSteps;
        this.setInputRowSets(Collections.emptyList());
        this.setOutputRowSets(Collections.emptyList());
        this.init();
    }

    @Override
    public void dispatch() {
    }

    @Override
    public Collection<StepStatus> subStatuses() {
        return this.subSteps.stream().map(combi -> new StepStatus(combi.step)).collect(Collectors.toList());
    }

    private void init() throws KettleException {
        this.createHandlerToMetrics();
        this.createHandlerToStatus();
        this.createHandlerToRows();
    }

    private void createHandlerToRows() throws KettleException {
        this.messageEventService.addHandler((Message)Util.getOperationRowEvent(this.operation.getId()), new MessageEventHandler(){

            @Override
            public void execute(Message message) throws MessageEventHandlerExecutionException {
                PDIEvent data = (PDIEvent)message;
                if (((Rows)data.getData()).getType().equals((Object)Rows.TYPE.OUT)) {
                    ((Rows)data.getData()).stream().forEach(r -> StepInterfaceWebSocketEngineAdapter.this.putRow(r));
                }
            }

            @Override
            public String getIdentifier() {
                return StepInterfaceWebSocketEngineAdapter.ROWS_HANDLER_ID + StepInterfaceWebSocketEngineAdapter.this.operation.getKey();
            }
        });
    }

    private void createHandlerToStatus() throws KettleException {
        this.messageEventService.addHandler((Message)Util.getOperationStatusEvent(this.operation.getId()), new MessageEventHandler(){

            @Override
            public void execute(Message message) throws MessageEventHandlerExecutionException {
                PDIEvent data = (PDIEvent)message;
                switch ((Status)data.getData()) {
                    case RUNNING: {
                        StepInterfaceWebSocketEngineAdapter.this.setRunning(true);
                        break;
                    }
                    case PAUSED: {
                        StepInterfaceWebSocketEngineAdapter.this.setPaused(true);
                        break;
                    }
                    case FAILED: {
                        StepInterfaceWebSocketEngineAdapter.this.setErrors(1L);
                    }
                    case STOPPED: {
                        StepInterfaceWebSocketEngineAdapter.this.setStopped(true);
                        break;
                    }
                    case FINISHED: {
                        StepInterfaceWebSocketEngineAdapter.this.setRunning(false);
                    }
                }
            }

            @Override
            public String getIdentifier() {
                return StepInterfaceWebSocketEngineAdapter.OPERATION_STATUS_HANDLER_ID + StepInterfaceWebSocketEngineAdapter.this.operation.getKey();
            }
        });
    }

    private void createHandlerToMetrics() throws KettleException {
        this.messageEventService.addHandler((Message)Util.getMetricEvents(this.operation.getId()), new MessageEventHandler(){

            @Override
            public void execute(Message message) throws MessageEventHandlerExecutionException {
                PDIEvent data = (PDIEvent)message;
                if (((Metrics)data.getData()).getIn() > 0L) {
                    StepInterfaceWebSocketEngineAdapter.this.setLinesRead(((Metrics)data.getData()).getIn());
                }
                if (((Metrics)data.getData()).getOut() > 0L) {
                    StepInterfaceWebSocketEngineAdapter.this.setLinesWritten(((Metrics)data.getData()).getOut());
                }
            }

            @Override
            public String getIdentifier() {
                return StepInterfaceWebSocketEngineAdapter.METRICS_HANDLER_ID + StepInterfaceWebSocketEngineAdapter.this.operation.getKey();
            }
        });
    }

    private void putRow(Row row) {
    }
}

