/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket.exception;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;

public class MessageEventFireEventException
extends KettleException {
    private static final long serialVersionUID = 1107793379573661562L;
    private List<Exception> handlerExceptions;

    public MessageEventFireEventException(String message) {
        super(message);
    }

    public void addHandlerException(Exception e) {
        if (this.handlerExceptions == null) {
            this.handlerExceptions = new ArrayList<Exception>();
        }
        this.handlerExceptions.add(e);
    }

    private List<Exception> getHandlerExceptions() {
        if (this.handlerExceptions != null) {
            return this.handlerExceptions;
        }
        return Collections.emptyList();
    }

    public String getMessage() {
        StringBuilder retval = new StringBuilder();
        retval.append(Const.CR).append(super.getMessage()).append(Const.CR);
        List<Exception> exceptions = this.getHandlerExceptions();
        for (Exception e : exceptions) {
            String message = e.getMessage();
            if (message != null) {
                retval.append(message).append(Const.CR);
                continue;
            }
            StackTraceElement[] ste = e.getStackTrace();
            for (int i = ste.length - 1; i >= 0; --i) {
                retval.append(" at ").append(ste[i].getClassName()).append(".").append(ste[i].getMethodName()).append(" (").append(ste[i].getFileName()).append(":").append(ste[i].getLineNumber()).append(")").append(Const.CR);
            }
        }
        return retval.toString();
    }
}

