/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.validator;

import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.trans.steps.validator.Validation;
import org.pentaho.di.trans.steps.validator.Validator;

public class KettleValidatorException
extends KettleValueException {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NULL_VALUE_NOT_ALLOWED = 1;
    public static final int ERROR_LONGER_THAN_MAXIMUM_LENGTH = 2;
    public static final int ERROR_SHORTER_THAN_MINIMUM_LENGTH = 3;
    public static final int ERROR_UNEXPECTED_DATA_TYPE = 4;
    public static final int ERROR_LOWER_THAN_ALLOWED_MINIMUM = 5;
    public static final int ERROR_HIGHER_THAN_ALLOWED_MAXIMUM = 6;
    public static final int ERROR_VALUE_NOT_IN_LIST = 7;
    public static final int ERROR_NON_NUMERIC_DATA = 8;
    public static final int ERROR_DOES_NOT_START_WITH_STRING = 9;
    public static final int ERROR_DOES_NOT_END_WITH_STRING = 10;
    public static final int ERROR_STARTS_WITH_STRING = 11;
    public static final int ERROR_ENDS_WITH_STRING = 12;
    public static final int ERROR_MATCHING_REGULAR_EXPRESSION_EXPECTED = 13;
    public static final int ERROR_MATCHING_REGULAR_EXPRESSION_NOT_ALLOWED = 14;
    public static final int ERROR_ONLY_NULL_VALUE_ALLOWED = 15;
    private static final String[] errorCode = new String[]{"KVD000", "KVD001", "KVD002", "KVD003", "KVD004", "KVD005", "KVD006", "KVD007", "KVD008", "KVD009", "KVD010", "KVD011", "KVD012", "KVD013", "KVD014", "KVD015"};
    private Validator validator;
    private Validation validatorField;
    private int code;
    private String fieldname;
    private static final long serialVersionUID = -212228277329271284L;

    public KettleValidatorException(Validator validator, Validation validatorField, int code, String message, String fieldname) {
        super(message);
        this.validator = validator;
        this.validatorField = validatorField;
        this.code = code;
        this.fieldname = fieldname;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getCodeDesc() {
        if (!Utils.isEmpty((CharSequence)this.validatorField.getErrorCode())) {
            String validatorCode = this.validator.environmentSubstitute(this.validatorField.getErrorCode());
            return validatorCode;
        }
        return errorCode[this.code];
    }

    public String getMessage() {
        if (!Utils.isEmpty((CharSequence)this.validatorField.getErrorDescription())) {
            return this.validator.environmentSubstitute(this.validatorField.getErrorDescription());
        }
        return super.getMessage();
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public Validation getValidatorField() {
        return this.validatorField;
    }

    public void setValidatorField(Validation validatorField) {
        this.validatorField = validatorField;
    }
}

