/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nce.common.sshclientstarter.migrate;

import com.huawei.nce.common.sshclientstarter.migrate.SshSQLBuilder;
import com.huawei.ncecommon.etl.util.service.api.ETLUtilFieldHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.steps.tableoutput.TableOutputData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshSQLExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SshSQLExecutor.class);
    private static final LoggingObjectInterface LOGGING_OBJECT = new LoggingObject((Object)"SshSQLExecutor");
    private static final String PATH = System.getProperty("user.dir") + File.separator + "pub" + File.separator + "sshDynamicMigrate.properties";
    private static final String GET_CONNECTION_FAILED_LOG = "get database connection failed.";
    private static final String ZENITH_PREFIX = "zenith-";
    private static final String YANG_PATH = "yang_path";
    private static final String KEY_NAME = "key_name";
    private static final String KEY_VALUE = "key_value";
    private static final int INDEX_1 = 1;
    private static final int INDEX_2 = 2;
    private static String sourceDbType;

    private SshSQLExecutor() {
    }

    public static void insertConfigData(ETLUtilFieldHelper helper, String dataBase, List<Map<String, String>> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        Database zenithDB = SshSQLExecutor.getZenithDatabase(helper, ZENITH_PREFIX + dataBase);
        SshSQLExecutor.preCheckDatabase(zenithDB != null, GET_CONNECTION_FAILED_LOG);
        String insertConfigDataSql = SshSQLBuilder.getInsertConfigData();
        Connection zenithConnection = zenithDB.getConnection();
        try (PreparedStatement insertStmt = zenithConnection.prepareStatement(insertConfigDataSql);){
            for (Map<String, String> config : data) {
                insertStmt.setString(1, config.get(KEY_NAME));
                insertStmt.setString(2, config.get(KEY_VALUE));
                insertStmt.addBatch();
            }
            insertStmt.executeBatch();
            zenithConnection.commit();
        }
        catch (SQLException e) {
            LOG.error("insert sshclient config data failed");
            throw new IllegalStateException("insert sshclient config data failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> queryYangPathByTableName(ETLUtilFieldHelper helper, String dataBase, String tableName) {
        Database gaussDB = SshSQLExecutor.getDatabase(helper, dataBase);
        SshSQLExecutor.preCheckDatabase(gaussDB != null, GET_CONNECTION_FAILED_LOG);
        try {
            Throwable throwable;
            ResultSet rs;
            block45: {
                gaussDB.connect();
                String queryYangPath = SshSQLBuilder.queryYangPathByTableName(tableName);
                try {
                    HashMap<String, String> hashMap;
                    Connection gsConn;
                    block50: {
                        gsConn = gaussDB.getConnection();
                        Throwable throwable2 = null;
                        try {
                            block48: {
                                PreparedStatement ptst;
                                block49: {
                                    ptst = gsConn.prepareStatement(queryYangPath);
                                    Throwable throwable3 = null;
                                    try {
                                        block46: {
                                            block47: {
                                                rs = ptst.executeQuery();
                                                throwable = null;
                                                try {
                                                    if (!rs.next()) break block45;
                                                    HashMap<String, String> result = new HashMap<String, String>();
                                                    result.put(YANG_PATH, rs.getString(YANG_PATH));
                                                    hashMap = result;
                                                    if (rs == null) break block46;
                                                    if (throwable == null) break block47;
                                                }
                                                catch (Throwable throwable4) {
                                                    try {
                                                        throwable = throwable4;
                                                        throw throwable4;
                                                    }
                                                    catch (Throwable throwable5) {
                                                        if (rs == null) throw throwable5;
                                                        if (throwable == null) {
                                                            rs.close();
                                                            throw throwable5;
                                                        }
                                                        try {
                                                            rs.close();
                                                            throw throwable5;
                                                        }
                                                        catch (Throwable throwable6) {
                                                            throwable.addSuppressed(throwable6);
                                                            throw throwable5;
                                                        }
                                                    }
                                                }
                                                try {
                                                    rs.close();
                                                }
                                                catch (Throwable throwable7) {
                                                    throwable.addSuppressed(throwable7);
                                                }
                                                break block46;
                                            }
                                            rs.close();
                                        }
                                        if (ptst == null) break block48;
                                        if (throwable3 == null) break block49;
                                    }
                                    catch (Throwable throwable8) {
                                        throwable3 = throwable8;
                                        throw throwable8;
                                    }
                                    catch (Throwable throwable9) {
                                        throw throwable9;
                                    }
                                    try {
                                        ptst.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable3.addSuppressed(throwable10);
                                    }
                                    break block48;
                                }
                                ptst.close();
                            }
                            if (gsConn == null) return hashMap;
                            if (throwable2 == null) break block50;
                        }
                        catch (Throwable throwable11) {
                            throwable2 = throwable11;
                            throw throwable11;
                        }
                        catch (Throwable throwable12) {
                            throw throwable12;
                        }
                        try {
                            gsConn.close();
                            return hashMap;
                        }
                        catch (Throwable throwable13) {
                            throwable2.addSuppressed(throwable13);
                            return hashMap;
                        }
                    }
                    gsConn.close();
                    return hashMap;
                }
                catch (SQLException e) {
                    LOG.error("query yangPath failed for {}", (Object)tableName);
                    throw new IllegalStateException("query yangPath failed for " + tableName);
                }
            }
            if (rs == null) return Collections.emptyMap();
            if (throwable == null) {
                rs.close();
                return Collections.emptyMap();
            }
            try {
                rs.close();
                return Collections.emptyMap();
            }
            catch (Throwable throwable14) {
                throwable.addSuppressed(throwable14);
                return Collections.emptyMap();
            }
        }
        catch (KettleDatabaseException e) {
            LOG.error("query yangPath failed for {}", (Object)tableName);
            throw new IllegalStateException(e);
        }
        finally {
            gaussDB.disconnect();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> queryConfigData(ETLUtilFieldHelper helper, String dataBase, String sql) {
        Database gaussDB = SshSQLExecutor.getDatabase(helper, dataBase);
        SshSQLExecutor.preCheckDatabase(gaussDB != null, GET_CONNECTION_FAILED_LOG);
        try {
            Throwable throwable;
            ResultSet rs;
            block45: {
                gaussDB.connect();
                try {
                    HashMap<String, String> hashMap;
                    Connection gsConn;
                    block50: {
                        gsConn = gaussDB.getConnection();
                        Throwable throwable2 = null;
                        try {
                            block48: {
                                PreparedStatement ptst;
                                block49: {
                                    ptst = gsConn.prepareStatement(sql);
                                    Throwable throwable3 = null;
                                    try {
                                        block46: {
                                            block47: {
                                                rs = ptst.executeQuery();
                                                throwable = null;
                                                try {
                                                    if (!rs.next()) break block45;
                                                    HashMap<String, String> result = new HashMap<String, String>();
                                                    result.put(KEY_NAME, rs.getString(KEY_NAME));
                                                    result.put(KEY_VALUE, rs.getString(KEY_VALUE));
                                                    hashMap = result;
                                                    if (rs == null) break block46;
                                                    if (throwable == null) break block47;
                                                }
                                                catch (Throwable throwable4) {
                                                    try {
                                                        throwable = throwable4;
                                                        throw throwable4;
                                                    }
                                                    catch (Throwable throwable5) {
                                                        if (rs == null) throw throwable5;
                                                        if (throwable == null) {
                                                            rs.close();
                                                            throw throwable5;
                                                        }
                                                        try {
                                                            rs.close();
                                                            throw throwable5;
                                                        }
                                                        catch (Throwable throwable6) {
                                                            throwable.addSuppressed(throwable6);
                                                            throw throwable5;
                                                        }
                                                    }
                                                }
                                                try {
                                                    rs.close();
                                                }
                                                catch (Throwable throwable7) {
                                                    throwable.addSuppressed(throwable7);
                                                }
                                                break block46;
                                            }
                                            rs.close();
                                        }
                                        if (ptst == null) break block48;
                                        if (throwable3 == null) break block49;
                                    }
                                    catch (Throwable throwable8) {
                                        throwable3 = throwable8;
                                        throw throwable8;
                                    }
                                    catch (Throwable throwable9) {
                                        throw throwable9;
                                    }
                                    try {
                                        ptst.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable3.addSuppressed(throwable10);
                                    }
                                    break block48;
                                }
                                ptst.close();
                            }
                            if (gsConn == null) return hashMap;
                            if (throwable2 == null) break block50;
                        }
                        catch (Throwable throwable11) {
                            throwable2 = throwable11;
                            throw throwable11;
                        }
                        catch (Throwable throwable12) {
                            throw throwable12;
                        }
                        try {
                            gsConn.close();
                            return hashMap;
                        }
                        catch (Throwable throwable13) {
                            throwable2.addSuppressed(throwable13);
                            return hashMap;
                        }
                    }
                    gsConn.close();
                    return hashMap;
                }
                catch (SQLException e) {
                    LOG.error("query yangPath failed");
                    throw new IllegalStateException("query yangPath failed");
                }
            }
            if (rs == null) return Collections.emptyMap();
            if (throwable == null) {
                rs.close();
                return Collections.emptyMap();
            }
            try {
                rs.close();
                return Collections.emptyMap();
            }
            catch (Throwable throwable14) {
                throwable.addSuppressed(throwable14);
                return Collections.emptyMap();
            }
        }
        catch (KettleDatabaseException e) {
            LOG.error("query yangPath failed");
            throw new IllegalStateException(e);
        }
        finally {
            gaussDB.disconnect();
        }
    }

    public static Database getDatabase(ETLUtilFieldHelper helper, String database) {
        String sourceType = Optional.ofNullable(sourceDbType).orElse("gauss");
        String sourceDatabase = sourceType + "-" + database;
        DatabaseMeta dbmeta = null;
        boolean find = false;
        List list = helper.getBase().getTransMeta().getDatabases();
        if (list != null && !list.isEmpty()) {
            for (DatabaseMeta meta : list) {
                dbmeta = meta;
                if (!sourceDatabase.equalsIgnoreCase(dbmeta.getName())) continue;
                find = true;
                break;
            }
        }
        if (find) {
            return new Database(LOGGING_OBJECT, dbmeta);
        }
        LOG.error("get database failed: {}", (Object)sourceDatabase);
        return null;
    }

    public static Database getZenithDatabase(ETLUtilFieldHelper helper, String database) {
        Trans trans = helper.getBase().getTrans();
        List steps = trans.getSteps();
        Database zenithDb = null;
        try {
            for (StepMetaDataCombi sdi : steps) {
                if (!(sdi.data instanceof TableOutputData)) continue;
                zenithDb = SshSQLExecutor.tryConnect((TableOutputData)sdi.data);
                break;
            }
        }
        catch (KettleDatabaseException e) {
            LOG.error("Get DB{} Connection Fialed", (Object)database);
        }
        if (zenithDb != null) {
            return zenithDb;
        }
        LOG.error("Get DB{} Connection Fialed", (Object)database);
        return null;
    }

    public static boolean isSourceDbZenith() {
        return sourceDbType != null && sourceDbType.equalsIgnoreCase("zenith");
    }

    private static Database tryConnect(TableOutputData data) throws KettleDatabaseException {
        if (data != null) {
            Database zenithDb = data.db;
            if (zenithDb != null && null == zenithDb.getConnection()) {
                zenithDb.connect();
            }
            return zenithDb;
        }
        return null;
    }

    private static void preCheckDatabase(boolean condition, String errorMsg) {
        if (!condition) {
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    static {
        File propFile = new File(PATH);
        if (!propFile.exists()) {
            LOG.warn("Properties file not found.");
        }
        try (InputStream in = Files.newInputStream(Paths.get(PATH, new String[0]), new OpenOption[0]);){
            Properties prop = new Properties();
            prop.load(in);
            sourceDbType = prop.getProperty("sourceType");
        }
        catch (IOException e) {
            LOG.warn("failed to read properties!");
        }
    }
}

