/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nce.common.snmpagenttarter.migrate;

import com.huawei.nce.common.snmpagenttarter.migrate.SnmpAgentSQLBuilder;
import com.huawei.nce.common.snmpagenttarter.migrate.SnmpAgentSQLExecutor;
import com.huawei.nce.common.snmpagenttarter.migrate.TerminateException;
import com.huawei.ncecommon.etl.util.service.api.ETLUtilFieldHelper;
import com.huawei.ncecommon.etl.util.service.api.IETLUtilService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpAgentJsonTableConvertor
implements IETLUtilService {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpAgentJsonTableConvertor.class);
    private static final Object LOCK = new Object();
    private static final Integer PATTERN_JSON = 1;
    private static final Integer DIS_MATCH = 99;
    private static final int NUM_TWO = 2;
    private static final String JSON_TABLE_PATTERN = "TB_\\d+";
    private static final String JSON_TABLE_PATTERN_LOWER = "tb_\\d+";
    private static final Map<String, Integer> TABLE_PATTERN_MAP = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] processRow(boolean first, ETLUtilFieldHelper helper, Object[] row, String tableName, String database) {
        Object object = LOCK;
        synchronized (object) {
            int tableType = this.matchTable(tableName);
            LOG.info("[SnmpAgent]Process table name:{}, type:{}", (Object)tableName, (Object)tableType);
            if (first && database != null && tableType != DIS_MATCH) {
                LOG.info("[SnmpAgent]Match table type and start to handle table :{}", (Object)tableName);
                if (tableType == PATTERN_JSON) {
                    String dbName = this.getDBName(database);
                    this.processMigrateForJson(helper, tableName, dbName);
                    LOG.info("[SnmpAgent]Finished to process table name:{}, type:{}", (Object)tableName, (Object)tableType);
                    return new Object[0];
                }
            }
            if (tableType == PATTERN_JSON && row != null) {
                try {
                    helper.setValue("id", null);
                }
                catch (Exception e) {
                    LOG.error("[SnmpAgent]Failed to set id to null ", (Throwable)e);
                }
            }
            return row;
        }
    }

    private String getDBName(String database) {
        String dbName = database;
        String[] databaseInfo = database.split("-");
        if (database.split("-").length == 2) {
            dbName = databaseInfo[1];
        }
        return dbName;
    }

    private void processMigrateForJson(ETLUtilFieldHelper helper, String tableName, String dbName) {
        try {
            String yangPath = SnmpAgentSQLExecutor.queryYangPathByTableName(helper, dbName, tableName);
            if (!SnmpAgentSQLBuilder.matchConvertTable(yangPath)) {
                LOG.info("[SnmpAgent] The table is not handled by snmp agent");
                return;
            }
            LOG.info("[SnmpAgent]Begin to convert data for {}, table:{}", (Object)yangPath, (Object)tableName);
            List<List<Object>> insertValue = this.queryConfigByTableType(helper, tableName, dbName, yangPath);
            SnmpAgentSQLExecutor.insertData(helper, dbName, insertValue, yangPath);
        }
        catch (TerminateException e) {
            LOG.info("[SnmpAgent] No need continue", (Throwable)e);
        }
    }

    private List<List<Object>> queryConfigByTableType(ETLUtilFieldHelper helper, String tableName, String dbName, String yangPath) throws TerminateException {
        switch (yangPath) {
            case "urn_huawei_yang_huawei_ac_snmp_augment_cfg_engine": {
                return Collections.singletonList(SnmpAgentSQLExecutor.convertEngineInfo(SnmpAgentSQLExecutor.queryJsdocData(helper, dbName, tableName)));
            }
            case "urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_vacm_view": {
                return SnmpAgentSQLExecutor.convertViewInfo(SnmpAgentSQLExecutor.queryJsdocData(helper, dbName, tableName));
            }
            case "urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_vacm_group_access": 
            case "urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_vacm_group": {
                return SnmpAgentSQLExecutor.convertGroupInfo(SnmpAgentSQLExecutor.queryJsdocData(helper, dbName, tableName), yangPath);
            }
            case "urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_usm_local_user": {
                return SnmpAgentSQLExecutor.convertUserInfo(SnmpAgentSQLExecutor.queryJsdocData(helper, dbName, tableName));
            }
            case "urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_target_params": {
                return SnmpAgentSQLExecutor.convertTargetParamInfo(SnmpAgentSQLExecutor.queryJsdocData(helper, dbName, tableName));
            }
            case "urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_target": 
            case "urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_notify": {
                return SnmpAgentSQLExecutor.convertTargetInfo(SnmpAgentSQLExecutor.queryJsdocData(helper, dbName, tableName), yangPath);
            }
            case "urn_huawei_yang_huawei_ac_iui_snmp_statistics_snmpagent_packet_statistics_packet_statistics_packet_statistics_info": {
                return SnmpAgentSQLExecutor.convertPacketInfo(SnmpAgentSQLExecutor.queryJsdocData(helper, dbName, tableName));
            }
            case "urn_huawei_yang_huawei_ac_iui_snmp_statistics_snmpagent_packet_statistics_fault_statistics_fault_statistics_info": {
                return SnmpAgentSQLExecutor.convertFaultInfo(SnmpAgentSQLExecutor.queryJsdocData(helper, dbName, tableName));
            }
        }
        return Collections.emptyList();
    }

    private int matchTable(String tableName) {
        for (Map.Entry<String, Integer> patternEntry : TABLE_PATTERN_MAP.entrySet()) {
            if (!Pattern.compile(patternEntry.getKey()).matcher(tableName).find()) continue;
            return patternEntry.getValue();
        }
        return DIS_MATCH;
    }

    static {
        TABLE_PATTERN_MAP.put(JSON_TABLE_PATTERN_LOWER, PATTERN_JSON);
        TABLE_PATTERN_MAP.put(JSON_TABLE_PATTERN, PATTERN_JSON);
    }
}

