/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nce.common.snmpagenttarter.migrate;

import com.alibaba.fastjson.JSONObject;
import com.huawei.nce.common.snmpagenttarter.migrate.SnmpAgentSQLBuilder;
import com.huawei.nce.common.snmpagenttarter.migrate.TerminateException;
import com.huawei.ncecommon.etl.util.service.api.ETLUtilFieldHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.steps.tableoutput.TableOutputData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpAgentSQLExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpAgentSQLExecutor.class);
    private static final LoggingObjectInterface LOGGING_OBJECT = new LoggingObject((Object)"SnmpAgentSQLExecutor");
    private static List<String> groupJsdocList;
    private static List<String> groupAccessList;
    private static List<String> targetJsdocList;
    private static List<String> targetNotifyJsdocList;
    private static final Map<String, String> CONVERT_MAP;
    private static final Pattern GROUP_PATTERN;
    private static final Pattern NUM_PATTERN;
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.S";

    private SnmpAgentSQLExecutor() {
    }

    public static void insertData(ETLUtilFieldHelper helper, String dataBase, List<List<Object>> data, String yangPath) {
        if (data == null || data.isEmpty()) {
            String err = "[SnmpAgent]Failed to insert data for " + yangPath + ", because inserting data is null";
            LOG.error(err);
            throw new IllegalStateException(err);
        }
        Database zenithDB = SnmpAgentSQLExecutor.getZenithDatabase(helper, "zenith-" + dataBase);
        SnmpAgentSQLExecutor.checkCondition(zenithDB == null, "[SnmpAgent]Failed to get database connection.");
        String insertSql = SnmpAgentSQLBuilder.getInsertSql(yangPath);
        Connection zenithConnection = zenithDB.getConnection();
        SnmpAgentSQLExecutor.preClear(yangPath, zenithConnection);
        try (PreparedStatement insertStmt = zenithConnection.prepareStatement(insertSql);){
            for (List<Object> list : data) {
                for (int i = 0; i < list.size(); ++i) {
                    insertStmt.setObject(i + 1, list.get(i));
                }
                insertStmt.addBatch();
            }
            insertStmt.executeBatch();
            zenithConnection.commit();
        }
        catch (SQLException e) {
            String err = "[SnmpAgent]Failed to insert data for " + yangPath;
            LOG.error("[SnmpAgent]Failed to insert data for {}, error code {}, sql status {}", new Object[]{yangPath, e.getErrorCode(), e.getSQLState()});
            throw new IllegalStateException(err);
        }
    }

    private static void preClear(String yangPath, Connection zenithConnection) {
        String deleteSql = SnmpAgentSQLBuilder.getDeleteSql(yangPath);
        if (deleteSql == null) {
            return;
        }
        try (PreparedStatement deleteStmt = zenithConnection.prepareStatement(deleteSql);){
            deleteStmt.execute();
            zenithConnection.commit();
        }
        catch (SQLException e) {
            String err = "[SnmpAgent]Failed to delete data for " + yangPath;
            LOG.error("[SnmpAgent]Failed to delete data for {}, error code {}, sql status {}", new Object[]{yangPath, e.getErrorCode(), e.getSQLState()});
            throw new IllegalStateException(err);
        }
    }

    public static String queryYangPathByTableName(ETLUtilFieldHelper helper, String dataBase, String tableName) {
        Database gaussDB = SnmpAgentSQLExecutor.getDatabase(helper, dataBase);
        SnmpAgentSQLExecutor.checkCondition(gaussDB == null, "[SnmpAgent]Failed to get database connection.");
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            gaussDB.connect();
            String queryYangPath = SnmpAgentSQLBuilder.queryYangPathByTableName(tableName);
            try (Connection gsConn = gaussDB.getConnection();
                 PreparedStatement ptst = gsConn.prepareStatement(queryYangPath);
                 ResultSet rs = ptst.executeQuery();){
                if (rs.next()) {
                    result.put("yang_path", rs.getString("yang_path"));
                }
            }
            catch (SQLException e) {
                String err = "[SnmpAgent]Failed to query yangPath for " + tableName;
                LOG.error(err);
                throw new IllegalStateException(err);
            }
        }
        catch (KettleDatabaseException e) {
            LOG.error("[SnmpAgent]Failed to query yangPath for {}", (Object)tableName);
            throw new IllegalStateException(e);
        }
        finally {
            gaussDB.disconnect();
        }
        SnmpAgentSQLExecutor.checkCondition(result.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)result.get("yang_path"))), "[SnmpAgent]Failed to get yang_path by table name" + tableName);
        return ((String)result.get("yang_path")).toLowerCase(Locale.ENGLISH);
    }

    public static List<Object> convertEngineInfo(List<String> jsdocs) {
        if (jsdocs.isEmpty()) {
            return null;
        }
        ArrayList<Object> convertResult = new ArrayList<Object>();
        JSONObject jsonObject = JSONObject.parseObject((String)jsdocs.get(0));
        JSONObject engine = jsonObject.getJSONObject("engine");
        convertResult.add(engine.getString("engine-id"));
        convertResult.add(Integer.valueOf(engine.getString("listen-port")));
        convertResult.add("v3");
        convertResult.add(Boolean.parseBoolean(engine.getString("enabled")));
        convertResult.add(Boolean.parseBoolean(engine.getString("sync-enable")));
        return convertResult;
    }

    public static List<List<Object>> convertViewInfo(List<String> jsdocList) {
        ArrayList<List<Object>> convertResult = new ArrayList<List<Object>>();
        for (String jsdoc : jsdocList) {
            JSONObject view = JSONObject.parseObject((String)jsdoc);
            String include = view.getString("include");
            ArrayList<String> list = new ArrayList<String>();
            list.add(view.getString("name"));
            if (include != null && include.length() != 0) {
                list.add(StringUtils.strip((String)include.replaceAll("\"", "").replaceAll(",", ", "), (String)"[]"));
            } else {
                list.add("");
            }
            String exclude = view.getString("exclude");
            if (exclude != null && exclude.length() != 0) {
                list.add(StringUtils.strip((String)exclude.replaceAll("\"", "").replaceAll(",", ", "), (String)"[]"));
            } else {
                list.add("");
            }
            convertResult.add(list);
        }
        return convertResult;
    }

    public static List<List<Object>> convertGroupInfo(List<String> jsdocList, String path) throws TerminateException {
        if ("urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_vacm_group_access".equals(path)) {
            groupAccessList = jsdocList;
        } else {
            groupJsdocList = jsdocList;
        }
        if (CollectionUtils.isEmpty(groupAccessList) || CollectionUtils.isEmpty(groupJsdocList)) {
            throw new TerminateException("[SnmpAgent]groupAccessList or groupJsdocList is empty, wait for next time");
        }
        ArrayList<List<Object>> convertResult = new ArrayList<List<Object>>();
        ArrayList<String> groupNames = new ArrayList<String>();
        groupJsdocList.forEach(jsdoc -> {
            JSONObject json = JSONObject.parseObject((String)jsdoc);
            groupNames.add(json.getString("name"));
        });
        for (String jsdoc2 : groupAccessList) {
            ArrayList<Object> list = new ArrayList<Object>();
            JSONObject json = JSONObject.parseObject((String)jsdoc2);
            SnmpAgentSQLExecutor.generateGroupName(groupNames, json, list);
            list.add(CONVERT_MAP.get(json.getString("security-model")));
            list.add(CONVERT_MAP.get(json.getString("security-level")));
            list.add(json.getString("context"));
            list.add(json.getString("context-match").toUpperCase(Locale.ENGLISH));
            list.add(json.getString("read-view"));
            list.add(json.getString("write-view"));
            list.add(json.getString("notify-view"));
            convertResult.add(list);
        }
        return convertResult;
    }

    private static void generateGroupName(List<String> groupNames, JSONObject json, List<Object> list) {
        Optional<String> groupName = groupNames.stream().filter(name -> {
            Matcher parentPath = GROUP_PATTERN.matcher(json.getString("parentPath"));
            if (parentPath.find()) {
                return name.equals(parentPath.group(0).split("=")[1].replaceAll("]", ""));
            }
            return false;
        }).findFirst();
        if (!groupName.isPresent()) {
            String error = "Failed to generate group info";
            LOG.error(error);
            throw new IllegalArgumentException(error);
        }
        list.add(groupName.get());
    }

    public static List<List<Object>> convertUserInfo(List<String> jsdocList) {
        ArrayList<List<Object>> convertResult = new ArrayList<List<Object>>();
        for (String jsdoc : jsdocList) {
            JSONObject json = JSONObject.parseObject((String)jsdoc);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(json.getString("name"));
            list.add(json.getString("engine-id"));
            list.add(json.getString("group-name"));
            if (json.getJSONObject("priv") == null || json.getJSONObject("auth") == null) {
                LOG.warn("Invalid user info about [{}]", (Object)json.getString("name"));
                continue;
            }
            SnmpAgentSQLExecutor.generatePrivInfo(list, json);
            SnmpAgentSQLExecutor.generateAuthInfo(list, json);
            convertResult.add(list);
        }
        return convertResult;
    }

    private static void generateAuthInfo(List<Object> list, JSONObject json) {
        JSONObject authObj = json.getJSONObject("auth");
        Optional<String> auth = CONVERT_MAP.keySet().stream().filter(key -> {
            boolean findAuth = authObj.toString().contains((CharSequence)key);
            if (findAuth) {
                list.add(CONVERT_MAP.get(key));
                JSONObject authProtocol = authObj.getJSONObject(key);
                list.add(authProtocol.getString("key"));
            }
            return findAuth;
        }).findFirst();
        if (!auth.isPresent()) {
            String error = "Failed to get auth protocol";
            LOG.error(error);
            throw new IllegalArgumentException(error);
        }
    }

    private static void generatePrivInfo(List<Object> list, JSONObject json) {
        JSONObject privObj = json.getJSONObject("priv");
        Optional<String> priv = CONVERT_MAP.keySet().stream().filter(key -> {
            boolean findPriv = privObj.toString().contains((CharSequence)key);
            if (findPriv) {
                list.add(CONVERT_MAP.get(key));
                JSONObject privProtocol = privObj.getJSONObject(key);
                list.add(privProtocol.getString("key"));
            }
            return findPriv;
        }).findFirst();
        if (!priv.isPresent()) {
            String error = "Failed to get priv protocol";
            LOG.error(error);
            throw new IllegalArgumentException(error);
        }
    }

    public static List<List<Object>> convertTargetParamInfo(List<String> jsdocList) {
        ArrayList<List<Object>> convertResult = new ArrayList<List<Object>>();
        for (String jsdoc : jsdocList) {
            ArrayList<String> list = new ArrayList<String>();
            JSONObject json = JSONObject.parseObject((String)jsdoc);
            list.add(json.getString("name"));
            list.add("USM");
            JSONObject usm = json.getJSONObject("usm");
            list.add(usm.getString("user-name"));
            list.add(CONVERT_MAP.get(usm.getString("security-level")));
            convertResult.add(list);
        }
        return convertResult;
    }

    public static List<List<Object>> convertTargetInfo(List<String> jsdocList, String yangPath) throws TerminateException {
        if ("urn_huawei_yang_huawei_ac_snmp_snmp_agent_cfg_notify".equals(yangPath)) {
            targetNotifyJsdocList = jsdocList;
        } else {
            targetJsdocList = jsdocList;
        }
        if (CollectionUtils.isEmpty(targetNotifyJsdocList) || CollectionUtils.isEmpty(targetJsdocList)) {
            String info = "[SnmpAgent]The current data cat't be handled for target, wait for next time";
            LOG.info(info);
            throw new TerminateException(info);
        }
        LOG.error("[SnmpAgent]Test targetNotifyJsdocList is {}, targetJsdocList is {}", targetNotifyJsdocList, targetJsdocList);
        HashMap<String, String> notifyMap = new HashMap<String, String>();
        for (String notify : targetNotifyJsdocList) {
            JSONObject json = JSONObject.parseObject((String)notify);
            String name = json.getString("name");
            String type = json.getString("type");
            if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)type)) {
                notifyMap.put(name, type);
                continue;
            }
            String error = "[SnmpAgent]Failed to get notify type";
            LOG.error(error);
            throw new IllegalArgumentException(error);
        }
        ArrayList<List<Object>> convertResult = new ArrayList<List<Object>>();
        for (String jsdoc : targetJsdocList) {
            JSONObject json = JSONObject.parseObject((String)jsdoc);
            String targetName = json.getString("name");
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(targetName);
            list.add(CONVERT_MAP.get(notifyMap.get(targetName)));
            JSONObject udp = json.getJSONObject("udp");
            list.add(udp.getString("ip"));
            list.add(Integer.valueOf(udp.getString("port")));
            list.add(Integer.valueOf(udp.getString("prefix-length")));
            list.add(Integer.valueOf(json.getString("timeout")));
            list.add(Integer.valueOf(json.getString("retries")));
            list.add(json.getString("target-params"));
            convertResult.add(list);
        }
        return convertResult;
    }

    public static List<List<Object>> convertPacketInfo(List<String> jsdocList) {
        ArrayList<List<Object>> convertResult = new ArrayList<List<Object>>();
        for (String jsdoc : jsdocList) {
            JSONObject json = JSONObject.parseObject((String)jsdoc);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(json.getString("ac-ip"));
            list.add(CONVERT_MAP.get(json.getString("op-type")));
            list.add(Integer.valueOf(json.getString("drop-num")));
            list.add(Integer.valueOf(json.getString("recv-total-num")));
            list.add(Integer.valueOf(json.getString("send-error-num")));
            list.add(Integer.valueOf(json.getString("recv-error-num")));
            list.add(Integer.valueOf(json.getString("send-total-num")));
            convertResult.add(list);
        }
        return convertResult;
    }

    public static List<List<Object>> convertFaultInfo(List<String> jsdocList) {
        ArrayList<List<Object>> convertResult = new ArrayList<List<Object>>();
        for (String jsdoc : jsdocList) {
            JSONObject json = JSONObject.parseObject((String)jsdoc);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(json.getString("ac-ip"));
            list.add(json.getString("ne-ip"));
            list.add(CONVERT_MAP.get(json.getString("op-type")));
            list.add(SnmpAgentSQLExecutor.formatTime(json.getString("first-fault-time")));
            list.add(SnmpAgentSQLExecutor.formatTime(json.getString("current-fault-time")));
            list.add(Integer.valueOf(json.getString("continuous-fault-num")));
            list.add(json.getString("fault-reason"));
            list.add(json.getString("user-name"));
            list.add(json.getString("comments"));
            convertResult.add(list);
        }
        return convertResult;
    }

    private static long formatTime(String oriTime) {
        try {
            if (NUM_PATTERN.matcher(oriTime).find()) {
                return Long.parseLong(oriTime);
            }
            return new SimpleDateFormat(TIME_FORMAT, Locale.US).parse(oriTime).getTime();
        }
        catch (ParseException e) {
            LOG.error("[Snmp Agent]Failed to parse date and time, oriTime is {}", (Object)oriTime, (Object)e);
            return System.currentTimeMillis();
        }
    }

    public static List<String> queryJsdocData(ETLUtilFieldHelper helper, String dataBase, String tableName) throws TerminateException {
        Database gaussDB = SnmpAgentSQLExecutor.getDatabase(helper, dataBase);
        String sql = SnmpAgentSQLBuilder.getJsdocQuerySql(tableName);
        ArrayList<String> result = new ArrayList<String>();
        SnmpAgentSQLExecutor.checkCondition(gaussDB == null, "[SnmpAgent]Failed to get database connection.");
        try {
            gaussDB.connect();
            try (Connection gsConn = gaussDB.getConnection();
                 PreparedStatement ptst = gsConn.prepareStatement(sql);
                 ResultSet rs = ptst.executeQuery();){
                while (rs.next()) {
                    String jsdoc = rs.getString("JSDOC");
                    if (jsdoc == null || jsdoc.length() == 0) continue;
                    result.add(jsdoc);
                }
            }
            catch (SQLException e) {
                String err = "[SnmpAgent]Failed to query jsdoc for table name " + tableName;
                LOG.error(err);
                throw new IllegalStateException(err);
            }
        }
        catch (KettleDatabaseException e) {
            LOG.error("[SnmpAgent]Failed to query jsdoc for table name {} ", (Object)tableName);
            throw new IllegalStateException(e);
        }
        finally {
            gaussDB.disconnect();
        }
        if (result.isEmpty()) {
            String info = "[SnmpAgent] jsdoc is null, no need to continue";
            LOG.info(info);
            throw new TerminateException(info);
        }
        LOG.error("[SnmpAgent]queryJsdocData {}, tableName is {}", result, (Object)tableName);
        return result;
    }

    public static Database getDatabase(ETLUtilFieldHelper helper, String database) {
        String sourceDatabase = "gauss-" + database;
        Optional<Object> find = Optional.empty();
        List list = helper.getBase().getTransMeta().getDatabases();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            find = list.stream().filter(meta -> sourceDatabase.equalsIgnoreCase(meta.getName())).findFirst();
        }
        if (find.isPresent()) {
            return new Database(LOGGING_OBJECT, (DatabaseMeta)find.get());
        }
        LOG.error("[SnmpAgent]Failed to et DB {} Connection", (Object)sourceDatabase);
        return null;
    }

    public static Database getZenithDatabase(ETLUtilFieldHelper helper, String database) {
        Trans trans = helper.getBase().getTrans();
        List steps = trans.getSteps();
        Database zenithDb = null;
        try {
            for (StepMetaDataCombi sdi : steps) {
                if (!(sdi.data instanceof TableOutputData)) continue;
                zenithDb = SnmpAgentSQLExecutor.tryConnect((TableOutputData)sdi.data);
                break;
            }
        }
        catch (KettleDatabaseException e) {
            LOG.error("[SnmpAgent]Failed to et DB{} Connection", (Object)database);
        }
        if (zenithDb != null) {
            return zenithDb;
        }
        LOG.error("[SnmpAgent]Failed to et DB{} Connection", (Object)database);
        return null;
    }

    private static Database tryConnect(TableOutputData data) throws KettleDatabaseException {
        if (data == null) {
            return null;
        }
        Database zenithDb = data.db;
        if (zenithDb != null && null == zenithDb.getConnection()) {
            zenithDb.connect();
        }
        return zenithDb;
    }

    public static void checkCondition(boolean condition, String errorMsg) {
        if (condition) {
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    static {
        CONVERT_MAP = new HashMap<String, String>();
        GROUP_PATTERN = Pattern.compile("\\[.*\\]");
        NUM_PATTERN = Pattern.compile("^[0-9]*$");
        CONVERT_MAP.put("auth-priv", "AUTH_PRIV");
        CONVERT_MAP.put("auth-no-priv", "AUTH_NO_PRIV");
        CONVERT_MAP.put("no-auth-no-priv", "NO_AUTH_NO_PRIV");
        CONVERT_MAP.put("sha", "SHA");
        CONVERT_MAP.put("md5", "MD5");
        CONVERT_MAP.put("sha2-224", "SHA2_224");
        CONVERT_MAP.put("sha2-256", "SHA2_256");
        CONVERT_MAP.put("sha2-384", "SHA2_384");
        CONVERT_MAP.put("sha2-512", "SHA2_512");
        CONVERT_MAP.put("aes", "AES");
        CONVERT_MAP.put("des", "DES");
        CONVERT_MAP.put("aes128", "AES128");
        CONVERT_MAP.put("usm", "USM");
        CONVERT_MAP.put("trap", "TRAP");
        CONVERT_MAP.put("inform", "INFORM");
        CONVERT_MAP.put("GET", "GET");
        CONVERT_MAP.put("GET-BULK", "GETBULK");
        CONVERT_MAP.put("GET-NEXT", "GETNEXT");
        CONVERT_MAP.put("GET-WALK", "GETWALK");
        CONVERT_MAP.put("TRAP", "TRAP");
        CONVERT_MAP.put("CONFIG", "CONFIG");
        CONVERT_MAP.put("SET", "SET");
    }
}

