/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.message.DeleteGroupCommitOffsetResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class DeleteGroupCommitOffsetResponse
extends AbstractResponse {
    public static final String RESULT_KEY_NAME = "result";
    private final DeleteGroupCommitOffsetResponseData data;

    public DeleteGroupCommitOffsetResponse(Errors error, String result) {
        super(ApiKeys.DELETE_GROUP_COMMIT_OFFSET);
        DeleteGroupCommitOffsetResponseData resData = new DeleteGroupCommitOffsetResponseData();
        resData.setErrorCode(error.code());
        resData.setResult(result);
        this.data = resData;
    }

    public DeleteGroupCommitOffsetResponse(DeleteGroupCommitOffsetResponseData data) {
        super(ApiKeys.DELETE_GROUP_COMMIT_OFFSET);
        this.data = data;
    }

    public static DeleteGroupCommitOffsetResponse parse(ByteBuffer buffer, short version) {
        return new DeleteGroupCommitOffsetResponse(new DeleteGroupCommitOffsetResponseData(new ByteBufferAccessor(buffer), version));
    }

    public static DeleteGroupCommitOffsetResponse fromError(Errors error) {
        return new DeleteGroupCommitOffsetResponse(error, "false");
    }

    public String result() {
        return this.data.result();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error());
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public DeleteGroupCommitOffsetResponseData data() {
        return this.data;
    }
}

