/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

public class RMISocketFactoryHelper {
    public static RMIServerSocketFactory createRMIServerSocketFactory(String serverClassName, InetAddress bindAddress) {
        Object obj = RMISocketFactoryHelper.createInstance(serverClassName, new Class[]{InetAddress.class}, new Object[]{bindAddress});
        if (obj instanceof RMIServerSocketFactory) {
            return (RMIServerSocketFactory)obj;
        }
        return null;
    }

    public static RMIClientSocketFactory createRMIClientSocketFactory(String clientClassName, InetAddress bindAddress) {
        Object obj = RMISocketFactoryHelper.createInstance(clientClassName, new Class[]{InetAddress.class}, new Object[]{bindAddress});
        if (obj instanceof RMIClientSocketFactory) {
            return (RMIClientSocketFactory)obj;
        }
        return null;
    }

    private static Object createInstance(String className, Class<?>[] ctorArgTypes, Object[] ctorArgs) {
        try {
            Class<?> cls = Class.forName(className);
            Constructor<?> ctor = cls.getDeclaredConstructor(ctorArgTypes);
            return ctor.newInstance(ctorArgs);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Unable to instantiate specified class " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Constructor threw an exception for " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Unable to find suitable constructor for class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Unable to access specified class " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to find class " + className, e);
        }
    }
}

