/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactoryInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;

public class CompressionProviderFactory
implements CompressionProviderFactoryInterface {
    protected static CompressionProviderFactory INSTANCE = new CompressionProviderFactory();

    private CompressionProviderFactory() {
    }

    public static CompressionProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public CompressionProvider createCompressionProviderInstance(String name) {
        Object provider = null;
        List<PluginInterface> providers = this.getPlugins();
        if (providers != null) {
            for (PluginInterface plugin : providers) {
                if (name == null || !name.equalsIgnoreCase(plugin.getName())) continue;
                try {
                    return (CompressionProvider)PluginRegistry.getInstance().loadClass(plugin, CompressionProvider.class);
                }
                catch (Exception e) {
                    provider = null;
                }
            }
        }
        return provider;
    }

    @Override
    public Collection<CompressionProvider> getCompressionProviders() {
        ArrayList<CompressionProvider> providerClasses = new ArrayList<CompressionProvider>();
        List<PluginInterface> providers = this.getPlugins();
        if (providers != null) {
            for (PluginInterface plugin : providers) {
                try {
                    providerClasses.add((CompressionProvider)PluginRegistry.getInstance().loadClass(plugin, CompressionProvider.class));
                }
                catch (Exception exception) {}
            }
        }
        return providerClasses;
    }

    @Override
    public String[] getCompressionProviderNames() {
        ArrayList<String> providerNames = new ArrayList<String>();
        List<PluginInterface> providers = this.getPlugins();
        if (providers != null) {
            for (PluginInterface plugin : providers) {
                try {
                    CompressionProvider provider = (CompressionProvider)PluginRegistry.getInstance().loadClass(plugin, CompressionProvider.class);
                    if (provider == null) continue;
                    providerNames.add(provider.getName());
                }
                catch (Exception exception) {}
            }
        }
        return providerNames.toArray(new String[providerNames.size()]);
    }

    @Override
    public CompressionProvider getCompressionProviderByName(String name) {
        if (name == null) {
            return null;
        }
        CompressionProvider foundProvider = null;
        List<PluginInterface> providers = this.getPlugins();
        if (providers != null) {
            for (PluginInterface plugin : providers) {
                try {
                    CompressionProvider provider = (CompressionProvider)PluginRegistry.getInstance().loadClass(plugin, CompressionProvider.class);
                    if (provider == null || !name.equals(provider.getName())) continue;
                    foundProvider = provider;
                }
                catch (Exception exception) {}
            }
        }
        return foundProvider;
    }

    protected List<PluginInterface> getPlugins() {
        return PluginRegistry.getInstance().getPlugins(CompressionPluginType.class);
    }
}

