/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.deletefiles;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryDeleteFiles
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryDeleteFiles.class;
    private boolean argFromPrevious = false;
    private boolean includeSubfolders = false;
    private String[] arguments = null;
    private String[] filemasks;

    public JobEntryDeleteFiles(String jobName) {
        super(jobName, "");
    }

    public JobEntryDeleteFiles() {
        this("");
    }

    public void allocate(int numberOfFields) {
        this.arguments = new String[numberOfFields];
        this.filemasks = new String[numberOfFields];
    }

    @Override
    public Object clone() {
        JobEntryDeleteFiles jobEntry = (JobEntryDeleteFiles)super.clone();
        if (this.arguments != null) {
            int nrFields = this.arguments.length;
            jobEntry.allocate(nrFields);
            System.arraycopy(this.arguments, 0, jobEntry.arguments, 0, nrFields);
            System.arraycopy(this.filemasks, 0, jobEntry.filemasks, 0, nrFields);
        }
        return jobEntry;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubfolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"filemask", (String)this.filemasks[i]));
                retval.append("        </field>").append(Const.CR);
                if (this.getParentJobMeta() == null) continue;
                this.getParentJobMeta().getNamedClusterEmbedManager().registerUrl(this.arguments[i]);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.includeSubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int numberOfFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(numberOfFields);
            for (int i = 0; i < numberOfFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.filemasks[i] = XMLHandler.getTagValue((Node)fnode, (String)"filemask");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.includeSubfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            int numberOfArgs = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.allocate(numberOfArgs);
            for (int i = 0; i < numberOfArgs; ++i) {
                this.arguments[i] = rep.getJobEntryAttributeString(id_jobentry, i, "name");
                this.filemasks[i] = rep.getJobEntryAttributeString(id_jobentry, i, "filemask");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.UnableToLoadFromRepo", (String[])new String[]{String.valueOf(id_jobentry)}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.includeSubfolders);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "name", this.arguments[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "filemask", this.filemasks[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.UnableToSaveToRepo", (String[])new String[]{String.valueOf(id_job)}), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result result, int nr) throws KettleException {
        List resultRows = result.getRows();
        int numberOfErrFiles = 0;
        result.setResult(false);
        result.setNrErrors(1L);
        if (this.argFromPrevious && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.FoundPreviousRows", (String[])new String[]{String.valueOf(resultRows != null ? resultRows.size() : 0)}));
        }
        if (this.parentJobMeta.getNamedClusterEmbedManager() != null) {
            this.parentJobMeta.getNamedClusterEmbedManager().passEmbeddedMetastoreKey(this, this.parentJobMeta.getEmbeddedMetastoreProviderKey());
        }
        Multimap<String, String> pathToMaskMap = this.populateDataForJobExecution(resultRows);
        for (Map.Entry pathToMask : pathToMaskMap.entries()) {
            String filePath = this.environmentSubstitute((String)pathToMask.getKey());
            if (filePath.trim().isEmpty()) {
                if (!this.log.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.NoPathProvided", (String[])new String[0]));
                continue;
            }
            String fileMask = this.environmentSubstitute((String)pathToMask.getValue());
            if (this.parentJob.isStopped()) break;
            if (this.processFile(filePath, fileMask, this.parentJob)) continue;
            ++numberOfErrFiles;
        }
        if (numberOfErrFiles == 0) {
            result.setResult(true);
            result.setNrErrors(0L);
        } else {
            result.setNrErrors((long)numberOfErrFiles);
            result.setResult(false);
        }
        return result;
    }

    private Multimap<String, String> populateDataForJobExecution(List<RowMetaAndData> rowsFromPreviousMeta) throws KettleValueException {
        ArrayListMultimap pathToMaskMap;
        block6: {
            block5: {
                pathToMaskMap = ArrayListMultimap.create();
                if (!this.argFromPrevious || rowsFromPreviousMeta == null) break block5;
                for (RowMetaAndData resultRow : rowsFromPreviousMeta) {
                    if (resultRow.size() < 2) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobDeleteFiles.Error.InvalidNumberOfRowsFromPrevMeta", (Object[])new Object[]{resultRow.size()}));
                        return pathToMaskMap;
                    }
                    String pathToFile = resultRow.getString(0, null);
                    String fileMask = resultRow.getString(1, null);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.ProcessingRow", (String[])new String[]{pathToFile, fileMask}));
                    }
                    pathToMaskMap.put((Object)pathToFile, (Object)fileMask);
                }
                break block6;
            }
            if (this.arguments == null) break block6;
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.ProcessingArg", (String[])new String[]{this.arguments[i], this.filemasks[i]}));
                }
                pathToMaskMap.put((Object)this.arguments[i], (Object)this.filemasks[i]);
            }
        }
        return pathToMaskMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processFile(String path, String wildcard, Job parentJob) {
        boolean isDeleted = false;
        FileObject fileFolder = null;
        try {
            fileFolder = KettleVFS.getFileObject((String)path, (VariableSpace)this);
            if (fileFolder.exists()) {
                if (fileFolder.getType() == FileType.FOLDER) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.ProcessingFolder", (String[])new String[]{path}));
                    }
                    int totalDeleted = fileFolder.delete((FileSelector)new TextFileSelector(fileFolder.toString(), wildcard, parentJob));
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.TotalDeleted", (String[])new String[]{String.valueOf(totalDeleted)}));
                    }
                    isDeleted = true;
                } else {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.ProcessingFile", (String[])new String[]{path}));
                    }
                    if (!(isDeleted = fileFolder.delete())) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.CouldNotDeleteFile", (String[])new String[]{path}));
                    } else if (this.log.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.FileDeleted", (String[])new String[]{path}));
                    }
                }
            } else {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.FileAlreadyDeleted", (String[])new String[]{path}));
                }
                isDeleted = true;
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.CouldNotProcess", (String[])new String[]{path, e.getMessage()}), e);
        }
        finally {
            if (fileFolder != null) {
                try {
                    fileFolder.close();
                }
                catch (IOException iOException) {}
            }
        }
        return isDeleted;
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public void setPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean isValid = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!isValid) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.arguments.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.arguments != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.arguments.length; ++i) {
                String filename = jobMeta.environmentSubstitute(this.arguments[i]);
                if (reference == null) {
                    reference = new ResourceReference(this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public void setFilemasks(String[] filemasks) {
        this.filemasks = filemasks;
    }

    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String[] getFilemasks() {
        return this.filemasks;
    }

    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;
        Job parentjob;

        public TextFileSelector(String sourcefolderin, String filewildcard, Job parentJob) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
            this.parentjob = parentJob;
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean doReturnCode = false;
            try {
                if (info.getFile().getType() == FileType.FILE && !this.parentjob.isStopped()) {
                    String shortFilename = info.getFile().getName().getBaseName();
                    if ((JobEntryDeleteFiles.this.includeSubfolders || info.getFile().getParent().equals(info.getBaseFolder())) && this.getFileWildcard(shortFilename, this.fileWildcard)) {
                        if (JobEntryDeleteFiles.this.log.isDetailed()) {
                            JobEntryDeleteFiles.this.logDetailed(BaseMessages.getString((Class)PKG, (String)"JobEntryDeleteFiles.DeletingFile", (String[])new String[]{info.getFile().toString()}));
                        }
                        doReturnCode = true;
                    }
                }
            }
            catch (Exception e) {
                JobEntryDeleteFiles.this.log.logError(BaseMessages.getString((Class)PKG, (String)"JobDeleteFiles.Error.Exception.DeleteProcessError", (String[])new String[0]), new Object[]{BaseMessages.getString((Class)PKG, (String)"JobDeleteFiles.Error.Exception.DeleteProcess", (String[])new String[]{info.getFile().toString(), e.getMessage()})});
                doReturnCode = false;
            }
            return doReturnCode;
        }

        private boolean hasAccess(FileObject fileObject) {
            try {
                if (fileObject instanceof LocalFile) {
                    return Files.isReadable(Paths.get(new File(fileObject.getName().getPath()).toURI()));
                }
                return fileObject.isReadable();
            }
            catch (FileSystemException e) {
                return false;
            }
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return (info.getDepth() == 0 || JobEntryDeleteFiles.this.includeSubfolders) && this.hasAccess(info.getFile());
        }

        private boolean getFileWildcard(String selectedfile, String wildcard) {
            boolean getIt = true;
            if (!Utils.isEmpty((CharSequence)wildcard)) {
                Pattern pattern = Pattern.compile(wildcard);
                Matcher matcher = pattern.matcher(selectedfile);
                getIt = matcher.matches();
            }
            return getIt;
        }
    }
}

