/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLParserFactoryProducer;
import org.pentaho.di.repository.RepositoryElementReadListener;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryExportSaxParser
extends DefaultHandler2 {
    public static final String STRING_REPOSITORY = "repository";
    public static final String STRING_TRANSFORMATIONS = "transformations";
    public static final String STRING_TRANSFORMATION = "transformation";
    public static final String STRING_JOBS = "jobs";
    public static final String STRING_JOB = "job";
    private SAXParser saxParser;
    private RepositoryElementReadListener repositoryElementReadListener;
    @VisibleForTesting
    final StringBuilder xml;
    private final String filename;
    private boolean add;
    private boolean cdata;
    RepositoryImportFeedbackInterface feedback;

    public RepositoryExportSaxParser(String filename, RepositoryImportFeedbackInterface feedback) {
        this.filename = filename;
        this.feedback = feedback;
        this.xml = new StringBuilder(50000);
        this.add = false;
        this.cdata = false;
    }

    public void parse(RepositoryElementReadListener repositoryElementReadListener) throws SAXException, ParserConfigurationException, IOException {
        this.repositoryElementReadListener = repositoryElementReadListener;
        SAXParserFactory factory = XMLParserFactoryProducer.createSecureSAXParserFactory();
        this.saxParser = factory.newSAXParser();
        this.saxParser.parse(new File(this.filename), (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        boolean bl = this.add = !STRING_REPOSITORY.equals(qName) && !STRING_TRANSFORMATIONS.equals(qName) && !STRING_JOBS.equals(qName);
        if (this.add) {
            if (STRING_TRANSFORMATION.equals(qName) || STRING_JOB.equals(qName)) {
                this.xml.setLength(0);
            }
            Map<Object, Object> attMap = Collections.emptyMap();
            if (attributes != null && attributes.getLength() > 0) {
                attMap = IntStream.range(0, attributes.getLength()).boxed().collect(Collectors.toMap(attributes::getQName, attributes::getValue));
            }
            XMLHandler.openTag((StringBuilder)this.xml, (String)qName, attMap);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.add) {
            XMLHandler.closeTag((StringBuilder)this.xml, (String)qName);
        }
        if (STRING_TRANSFORMATION.equals(qName)) {
            if (!this.repositoryElementReadListener.transformationElementRead(this.xml.toString(), this.feedback)) {
                this.saxParser.reset();
            }
        } else if (STRING_JOB.equals(qName) && !this.repositoryElementReadListener.jobElementRead(this.xml.toString(), this.feedback)) {
            this.saxParser.reset();
        }
    }

    @Override
    public void startCDATA() {
        this.cdata = true;
    }

    @Override
    public void endCDATA() {
        this.cdata = false;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.add) {
            String string = new String(ch, start, length);
            if (this.cdata) {
                XMLHandler.buildCDATA((StringBuilder)this.xml, (String)string);
            } else {
                XMLHandler.appendReplacedChars((StringBuilder)this.xml, (String)string);
            }
        }
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.repositoryElementReadListener.fatalXmlErrorEncountered(e);
    }
}

