/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.infobrightoutput;

import com.infobright.etl.model.BrighthouseRecord;
import com.infobright.etl.model.DataFormat;
import com.infobright.io.InfobrightNamedPipeLoader;
import com.infobright.logging.EtlLogger;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoader;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoaderMeta;
import org.pentaho.di.trans.steps.infobrightoutput.KettleEtlLogger;

public class InfobrightLoaderData
extends BaseStepData
implements StepDataInterface {
    private Database db;
    private String[] requiredFields;
    InfobrightNamedPipeLoader loader;
    BrighthouseRecord record;
    public RowMetaInterface requiredRowMeta;
    public RowMetaInterface outputRowMeta;
    public RowMetaInterface insertRowMeta;

    void databaseSetup(InfobrightLoaderMeta meta, InfobrightLoader step) throws KettleException {
        this.db = new Database((LoggingObjectInterface)step, meta.getDatabaseMeta());
        this.db.connect();
        this.requiredRowMeta = meta.getRequiredFields(step);
        this.requiredFields = this.requiredRowMeta.getFieldNames();
        try {
            if (meta.getInfobrightProductType() == null) {
                meta.setDataFormat(DataFormat.TXT_VARIABLE);
            }
            DataFormat dataFormat = DataFormat.valueForDisplayName((String)meta.getInfobrightProductType());
            int agentPort = meta.getAgentPort();
            Charset charset = meta.getCharset();
            Connection conn = this.db.getConnection();
            String tableName = meta.getDatabaseMeta().getQuotedSchemaTableCombination(step.environmentSubstitute(meta.getSchemaName()), step.environmentSubstitute(meta.getTableName()));
            KettleEtlLogger logger = new KettleEtlLogger(step);
            this.loader = new InfobrightNamedPipeLoader(tableName, conn, (EtlLogger)logger, dataFormat, charset, agentPort);
            this.loader.setTimeout(30);
            String debugFile = meta.getDebugFile();
            if (debugFile != null) {
                FileOutputStream debugOutputStream = new FileOutputStream(debugFile);
                this.loader.setDebugOutputStream((OutputStream)debugOutputStream);
            }
            this.record = this.loader.createRecord(false);
            this.loader.start();
        }
        catch (Exception e) {
            this.db.disconnect();
            this.db = null;
            if (this.loader != null) {
                try {
                    this.loader.killQuery();
                }
                catch (SQLException e1) {
                    throw new KettleDatabaseException((Throwable)e1);
                }
            }
            throw new KettleDatabaseException((Throwable)e);
        }
    }

    String[] getRequiredFields() {
        return this.requiredFields;
    }

    void dispose() throws Exception {
        try {
            if (this.loader != null) {
                this.loader.stop();
            }
            this.loader = null;
        }
        finally {
            if (this.db != null) {
                this.db.disconnect();
            }
            this.db = null;
        }
    }
}

