/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pentahoreporting.urlrepository;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;

public abstract class FileObjectContentEntity
implements ContentEntity,
Serializable {
    private FileObject backend;
    private ContentLocation parent;
    private Repository repository;
    private static final long serialVersionUID = 3962114134995757847L;

    protected FileObjectContentEntity(ContentLocation parent, FileObject backend) {
        if (backend == null) {
            throw new NullPointerException("Backend file must be given.");
        }
        if (parent == null) {
            throw new NullPointerException("Parent file must be given.");
        }
        this.repository = parent.getRepository();
        this.parent = parent;
        this.backend = backend;
    }

    protected FileObjectContentEntity(Repository repository, FileObject backend) {
        if (backend == null) {
            throw new NullPointerException("Backend file must be given.");
        }
        if (repository == null) {
            throw new NullPointerException("Repository file must be given.");
        }
        this.repository = repository;
        this.backend = backend;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getName() {
        return this.backend.getPublicURIString();
    }

    protected FileObject getBackend() {
        return this.backend;
    }

    public Object getContentId() {
        return this.backend;
    }

    public Object getAttribute(String domain, String key) {
        try {
            if ("org.jfree.repository".equals(domain)) {
                if ("size".equals(key)) {
                    return new Long(this.backend.getContent().getSize());
                }
                if ("version".equals(key)) {
                    return new Date(this.backend.getContent().getLastModifiedTime());
                }
            }
        }
        catch (FileSystemException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    public boolean setAttribute(String domain, String key, Object value) {
        try {
            if ("org.jfree.repository".equals(domain) && "version".equals(key)) {
                if (value instanceof Date) {
                    Date date = (Date)value;
                    this.backend.getContent().setLastModifiedTime(date.getTime());
                    return true;
                }
                if (value instanceof Number) {
                    Number time = (Number)value;
                    this.backend.getContent().setLastModifiedTime(time.longValue());
                    return true;
                }
            }
            return false;
        }
        catch (FileSystemException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public boolean delete() {
        try {
            this.backend.delete();
            return false;
        }
        catch (FileSystemException ex) {
            throw new RuntimeException(ex);
        }
    }
}

