/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.CryptoException;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.CryptoKeyException;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.SymmetricCryptoMeta;

public class SymmetricCrypto {
    private static Class<?> PKG = SymmetricCrypto.class;
    private SymmetricCryptoMeta meta;
    private Cipher cipher;
    private SecretKeySpec secretKeySpec;
    private String scheme;

    public SymmetricCrypto(SymmetricCryptoMeta meta) throws CryptoException {
        this.meta = meta;
        this.scheme = meta.getDefaultScheme();
        try {
            if (this.scheme == null) {
                throw new CryptoException(BaseMessages.getString(PKG, (String)"SymmetricCrypto.SchemeMissing", (String[])new String[0]));
            }
            this.cipher = Cipher.getInstance(this.scheme);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public SymmetricCrypto(SymmetricCryptoMeta meta, String xform) throws CryptoException {
        this.meta = meta;
        this.scheme = Const.NVL((String)xform, (String)meta.getDefaultScheme());
        try {
            if (this.scheme == null) {
                throw new CryptoException(BaseMessages.getString(PKG, (String)"SymmetricCrypto.SchemeMissing", (String[])new String[0]));
            }
            this.cipher = Cipher.getInstance(this.scheme);
        }
        catch (Exception e) {
            throw new CryptoException(BaseMessages.getString(PKG, (String)"SymmetricCrypto.SymmetricCrypto.Error.Cipher", (Object[])new Object[]{e}));
        }
    }

    public void setEncryptMode() throws CryptoException {
        try {
            this.cipher.init(1, this.secretKeySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public void setDecryptMode() throws CryptoException {
        try {
            this.cipher.init(2, this.secretKeySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public void setSecretKey(String keyString) throws CryptoKeyException {
        try {
            this.setSecretKey(Hex.decodeHex((char[])keyString.toCharArray()));
        }
        catch (Exception e) {
            throw new CryptoKeyException(e);
        }
    }

    public void setSecretKey(byte[] keyBytes) throws CryptoKeyException {
        try {
            this.secretKeySpec = new SecretKeySpec(keyBytes, this.meta.getAlgorithm());
        }
        catch (Exception e) {
            throw new CryptoKeyException(e);
        }
    }

    public void setSecretKeyFromFile(String filename) throws CryptoKeyException {
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject((String)filename);
            if (!file.exists()) {
                throw new CryptoException(BaseMessages.getString(PKG, (String)"SymmetricCrypto.CanNotFindFile", (Object[])new Object[]{file.getName()}));
            }
            byte[] KeyBytes = new byte[(int)file.getContent().getSize()];
            this.setSecretKey(KeyBytes);
        }
        catch (Exception e) {
            throw new CryptoKeyException(e);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public byte[] encrDecryptData(byte[] inpBytes) throws CryptoException {
        try {
            return this.cipher.doFinal(inpBytes);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public byte[] generateKey(int keySize) throws CryptoKeyException {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(this.meta.getAlgorithm());
            kg.init(keySize);
            SecretKey secretKey = kg.generateKey();
            return secretKey.getEncoded();
        }
        catch (Exception e) {
            throw new CryptoKeyException(e);
        }
    }

    public String generateKeyAsHex(int keySize) throws CryptoKeyException {
        return new String(Hex.encodeHex((byte[])this.generateKey(keySize)));
    }

    public String getCipherProviderName() {
        return this.cipher.getProvider().getName();
    }

    public void close() {
        this.cipher = null;
        this.secretKeySpec = null;
    }
}

