/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableexists;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableexists.TableExists;
import org.pentaho.di.trans.steps.tableexists.TableExistsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class TableExistsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = TableExistsMeta.class;
    private DatabaseMeta database;
    private String tablenamefield;
    private String resultfieldname;
    private String schemaname;

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String getDynamicTablenameField() {
        return this.tablenamefield;
    }

    public void setDynamicTablenameField(String tablenamefield) {
        this.tablenamefield = tablenamefield;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        TableExistsMeta retval = (TableExistsMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.database = null;
        this.schemaname = null;
        this.resultfieldname = "result";
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!Utils.isEmpty((CharSequence)this.resultfieldname)) {
            ValueMetaBoolean v = new ValueMetaBoolean(space.environmentSubstitute(this.resultfieldname));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.database == null ? "" : this.database.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"tablenamefield", (String)this.tablenamefield));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.database = DatabaseMeta.findDatabase(databases, (String)con);
            this.tablenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"tablenamefield");
            this.resultfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.schemaname = XMLHandler.getTagValue((Node)stepnode, (String)"schemaname");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TableExistsMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.database = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.tablenamefield = rep.getStepAttributeString(id_step, "tablenamefield");
            this.schemaname = rep.getStepAttributeString(id_step, "schemaname");
            this.resultfieldname = rep.getStepAttributeString(id_step, "resultfieldname");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TableExistsMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.database);
            rep.saveStepAttribute(id_transformation, id_step, "tablenamefield", this.tablenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "schemaname", this.schemaname);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultfieldname);
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TableExistsMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.database == null) {
            error_message = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Utils.isEmpty((CharSequence)this.resultfieldname)) {
            error_message = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Utils.isEmpty((CharSequence)this.tablenamefield)) {
            error_message = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.TableFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.TableFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TableExists(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TableExistsData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.database != null) {
            return new DatabaseMeta[]{this.database};
        }
        return super.getUsedDatabaseConnections();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

