/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.uniquerowsbyhashset;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.UniqueRowsByHashSet;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.UniqueRowsByHashSetData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class UniqueRowsByHashSetMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = UniqueRowsByHashSetMeta.class;
    private boolean storeValues;
    private String[] compareFields;
    private boolean rejectDuplicateRow;
    private String errorDescription;

    public void setCompareFields(String[] compareField) {
        this.compareFields = compareField;
    }

    public boolean getStoreValues() {
        return this.storeValues;
    }

    public void setStoreValues(boolean storeValues) {
        this.storeValues = storeValues;
    }

    public String[] getCompareFields() {
        return this.compareFields;
    }

    public void allocate(int nrfields) {
        this.compareFields = new String[nrfields];
    }

    public void setRejectDuplicateRow(boolean rejectDuplicateRow) {
        this.rejectDuplicateRow = rejectDuplicateRow;
    }

    public boolean isRejectDuplicateRow() {
        return this.rejectDuplicateRow;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        UniqueRowsByHashSetMeta retval = (UniqueRowsByHashSetMeta)super.clone();
        int nrfields = this.compareFields.length;
        retval.allocate(nrfields);
        System.arraycopy(this.compareFields, 0, retval.compareFields, 0, nrfields);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.storeValues = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"store_values"));
            this.rejectDuplicateRow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"reject_duplicate_row"));
            this.errorDescription = XMLHandler.getTagValue((Node)stepnode, (String)"error_description");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.compareFields[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.rejectDuplicateRow = false;
        this.errorDescription = null;
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.compareFields[i] = "field" + i;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("      " + XMLHandler.addTagValue((String)"store_values", (boolean)this.storeValues));
        retval.append("      " + XMLHandler.addTagValue((String)"reject_duplicate_row", (boolean)this.rejectDuplicateRow));
        retval.append("      " + XMLHandler.addTagValue((String)"error_description", (String)this.errorDescription));
        retval.append("    <fields>");
        for (int i = 0; i < this.compareFields.length; ++i) {
            retval.append("      <field>");
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.compareFields[i]));
            retval.append("        </field>");
        }
        retval.append("      </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.storeValues = rep.getStepAttributeBoolean(id_step, "store_values");
            this.rejectDuplicateRow = rep.getStepAttributeBoolean(id_step, "reject_duplicate_row");
            this.errorDescription = rep.getStepAttributeString(id_step, "error_description");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.compareFields[i] = rep.getStepAttributeString(id_step, i, "field_name");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "store_values", this.storeValues);
            rep.saveStepAttribute(id_transformation, id_step, "reject_duplicate_row", this.rejectDuplicateRow);
            rep.saveStepAttribute(id_transformation, id_step, "error_description", this.errorDescription);
            for (int i = 0; i < this.compareFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.compareFields[i]);
            }
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new UniqueRowsByHashSet(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new UniqueRowsByHashSetData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return this.isRejectDuplicateRow();
    }
}

