/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;

abstract class BaseRowSet
implements Comparable<RowSet>,
RowSet {
    protected RowMetaInterface rowMeta;
    protected AtomicBoolean done = new AtomicBoolean(false);
    protected volatile String originStepName;
    protected AtomicInteger originStepCopy = new AtomicInteger(0);
    protected volatile String destinationStepName;
    protected AtomicInteger destinationStepCopy = new AtomicInteger(0);
    protected volatile String remoteSlaveServerName;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public int compareTo(RowSet rowSet) {
        String target;
        this.lock.readLock().lock();
        try {
            target = this.remoteSlaveServerName + "." + this.destinationStepName + "." + this.destinationStepCopy.intValue();
        }
        finally {
            this.lock.readLock().unlock();
        }
        String comp = rowSet.getRemoteSlaveServerName() + "." + rowSet.getDestinationStepName() + "." + rowSet.getDestinationStepCopy();
        return target.compareTo(comp);
    }

    public boolean equals(BaseRowSet rowSet) {
        return this.compareTo(rowSet) == 0;
    }

    @Override
    public abstract boolean putRow(RowMetaInterface var1, Object[] var2);

    @Override
    public abstract boolean putRowWait(RowMetaInterface var1, Object[] var2, long var3, TimeUnit var5);

    @Override
    public abstract Object[] getRow();

    @Override
    public abstract Object[] getRowImmediate();

    @Override
    public abstract Object[] getRowWait(long var1, TimeUnit var3);

    @Override
    public void setDone() {
        this.done.set(true);
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public String getOriginStepName() {
        return this.originStepName;
    }

    @Override
    public int getOriginStepCopy() {
        return this.originStepCopy.get();
    }

    @Override
    public String getDestinationStepName() {
        return this.destinationStepName;
    }

    @Override
    public int getDestinationStepCopy() {
        return this.destinationStepCopy.get();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public abstract int size();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadNameFromToCopy(String from, int fromCopy, String to, int toCopy) {
        this.lock.writeLock().lock();
        try {
            this.originStepName = from;
            this.originStepCopy.set(fromCopy);
            this.destinationStepName = to;
            this.destinationStepCopy.set(toCopy);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuilder str;
        this.lock.readLock().lock();
        try {
            str = new StringBuilder(this.originStepName).append(".").append(this.originStepCopy).append(" - ").append(this.destinationStepName).append(".").append(this.destinationStepCopy);
            if (!Utils.isEmpty(this.remoteSlaveServerName)) {
                str.append(" (").append(this.remoteSlaveServerName).append(")");
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return str.toString();
    }

    @Override
    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    @Override
    public String getRemoteSlaveServerName() {
        return this.remoteSlaveServerName;
    }

    @Override
    public void setRemoteSlaveServerName(String remoteSlaveServerName) {
        this.remoteSlaveServerName = remoteSlaveServerName;
    }

    @Override
    public boolean isBlocking() {
        return false;
    }
}

