/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class StorageUnitConverter {
    public String byteCountToDisplaySize(long byteCount) {
        String spacedDisplaySize = FileUtils.byteCountToDisplaySize((long)byteCount);
        return spacedDisplaySize.replace("bytes", "B").replace(" ", "");
    }

    public long displaySizeToByteCount(String displaySize) {
        long returnValue = -1L;
        String displaySizeDecimal = displaySize == null ? "" : displaySize.replace(",", ".");
        Pattern pattern = Pattern.compile("([\\d.]+)([GMK]?B)", 2);
        Matcher matcher = pattern.matcher(displaySizeDecimal);
        HashMap<String, Integer> powerMap = new HashMap<String, Integer>();
        powerMap.put("GB", 3);
        powerMap.put("MB", 2);
        powerMap.put("KB", 1);
        powerMap.put("B", 0);
        if (matcher.find()) {
            String number = matcher.group(1);
            int pow = (Integer)powerMap.get(matcher.group(2).toUpperCase());
            BigDecimal bytes = new BigDecimal(number);
            bytes = bytes.multiply(BigDecimal.valueOf(1024L).pow(pow));
            returnValue = bytes.longValue();
        }
        return returnValue;
    }
}

