/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nce.common.sshclientstarter.migrate;

import com.huawei.nce.common.sshclientstarter.migrate.SshSQLBuilder;
import com.huawei.nce.common.sshclientstarter.migrate.SshSQLExecutor;
import com.huawei.ncecommon.etl.util.service.api.ETLUtilFieldHelper;
import com.huawei.ncecommon.etl.util.service.api.IETLUtilService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshJsonTableConvertor
implements IETLUtilService {
    private static final Logger LOG = LoggerFactory.getLogger(SshJsonTableConvertor.class);
    private static final Integer PATTERN_JSON = 1;
    private static final Integer DISMATCH = 99;
    private static final String YANG_PATH_FINGER_PRINT_CHECK = "com_huawei_controller_southbound_huawei_ac_ssh_client_first_add_fingerprint_check";
    private static final String YANG_PATH_RISK_SWITCH = "com_huawei_controller_southbound_huawei_ac_iui_ssh_client_risk_switch";
    private static final String YANG_PATH_TRUST_SELF_LEARN = "com_huawei_controller_southbound_huawei_ac_ssh_client_trust_self_learn_fingerprint";
    private static final String YANG_PATH_WEAK_ALGORITHM = "com_huawei_controller_southbound_huawei_ac_ssh_client_weak_algorithm";
    private static final int TABLE_FINGER_PRINT_CHECK = 1;
    private static final int TABLE_RISK_SWITCH = 2;
    private static final int TABLE_TRUST_SELF_LEARN = 3;
    private static final int TABLE_WEAK_ALGORITHM = 4;
    private static final int TABLE_UNKNOWN = 99;
    private static final int NUM_TWO = 2;
    private static final String JSON_TABLE_PATTERN = "TB_\\d+";
    private static final String JSON_TABLE_PATTERN_LOWER = "tb_\\d+";

    public Object[] processRow(boolean first, ETLUtilFieldHelper helper, Object[] row, String tableName, String database) {
        int tableType = this.matchTable(tableName);
        LOG.info("process tablename:{}, type:{}", (Object)tableName, (Object)tableType);
        if (first && database != null && tableType != DISMATCH) {
            String dbName = database;
            String[] databaseInfo = database.split("-");
            if (database.split("-").length == 2) {
                dbName = databaseInfo[1];
            }
            LOG.info("Start new database table :{}", (Object)tableName);
            if (tableType == PATTERN_JSON) {
                this.processMigrateForJson(helper, tableName, dbName);
                return new Object[0];
            }
        }
        if (tableType == PATTERN_JSON && row != null) {
            try {
                helper.setValue("id", null);
            }
            catch (Exception e) {
                LOG.error("set id to null failed", (Throwable)e);
            }
        }
        return row;
    }

    private void processMigrateForJson(ETLUtilFieldHelper helper, String tableName, String dbName) {
        Map<String, String> yangSchemaData = SshSQLExecutor.queryYangPathByTableName(helper, dbName, tableName);
        if (yangSchemaData.isEmpty()) {
            LOG.error("get yangSchemaData failed");
            throw new IllegalStateException("get yangSchemaData failed for database abnormal.");
        }
        String yangPath = yangSchemaData.get("yang_path");
        int tableType = this.matchConvertTable(yangPath);
        LOG.info("begin to convert data for {}, table:{}", (Object)yangPath, (Object)tableName);
        List<Map<String, String>> configData = this.queryConfigByTableType(helper, tableName, dbName, tableType);
        SshSQLExecutor.insertConfigData(helper, dbName, configData);
    }

    private List<Map<String, String>> queryConfigByTableType(ETLUtilFieldHelper helper, String tableName, String dbName, int type) {
        switch (type) {
            case 1: {
                return Arrays.asList(SshSQLExecutor.queryConfigData(helper, dbName, SshSQLBuilder.queryFingerPrintCheck(tableName, SshSQLExecutor.isSourceDbZenith())));
            }
            case 2: {
                return Arrays.asList(SshSQLExecutor.queryConfigData(helper, dbName, SshSQLBuilder.queryRiskSwitch(tableName, SshSQLExecutor.isSourceDbZenith())));
            }
            case 3: {
                return Arrays.asList(SshSQLExecutor.queryConfigData(helper, dbName, SshSQLBuilder.queryTrustSelfLearn(tableName, SshSQLExecutor.isSourceDbZenith())));
            }
            case 4: {
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
                result.add(SshSQLExecutor.queryConfigData(helper, dbName, SshSQLBuilder.queryWeakHmac(tableName, SshSQLExecutor.isSourceDbZenith())));
                result.add(SshSQLExecutor.queryConfigData(helper, dbName, SshSQLBuilder.queryWeakKex(tableName, SshSQLExecutor.isSourceDbZenith())));
                return result;
            }
        }
        return Collections.emptyList();
    }

    private int matchConvertTable(String yangPath) {
        HashMap<String, Integer> convertMap = new HashMap<String, Integer>();
        convertMap.put(YANG_PATH_FINGER_PRINT_CHECK, 1);
        convertMap.put(YANG_PATH_RISK_SWITCH, 2);
        convertMap.put(YANG_PATH_TRUST_SELF_LEARN, 3);
        convertMap.put(YANG_PATH_WEAK_ALGORITHM, 4);
        return convertMap.getOrDefault(yangPath, 99);
    }

    private int matchTable(String tableName) {
        HashMap<String, Integer> patternMap = new HashMap<String, Integer>();
        patternMap.put(JSON_TABLE_PATTERN_LOWER, PATTERN_JSON);
        patternMap.put(JSON_TABLE_PATTERN, PATTERN_JSON);
        for (Map.Entry patternEntry : patternMap.entrySet()) {
            if (!Pattern.compile((String)patternEntry.getKey()).matcher(tableName).find()) continue;
            return (Integer)patternEntry.getValue();
        }
        return DISMATCH;
    }
}

