#!/bin/bash
# Close all logical replication processes with paths under the LOGICREP_HOME environment variable.
# Copyright © Huawei Technologies Co., Ltd. 2010-2019. All rights reserved.

curr_path=${LOGICREP_HOME}
if [ "$curr_path" == "" ];then
    exit 0
fi

os_user=$(whoami)
file_user=`ls -l ${curr_path}"/shutdown_all_logicrep.sh" | awk '{print $3}'`

if [[ ${file_user} != ${os_user} ]] || [[ ${os_user} == root ]]; then
    echo "Can't run shutdown_all_logicrep.sh, because it does not belong to the current user or the user is root."
    exit 1
fi

ps -ux |grep ZLogCatcherMain |grep -v grep|grep -w "${curr_path}"|awk -F ' ' '{print $2}'|xargs kill -9 2>/dev/null 
echo "Close logic replication process successfully."

exit 0 
