#!/bin/bash
# logic rep start shell.
# Copyright © Huawei Technologies Co., Ltd. 2010-2019. All rights reserved.

set +e

# find app home directory
APP_HOME=$(cd `dirname $0`;pwd)

curr_path=$(dirname $(readlink -f $0))
os_user=$(whoami)
file_user=`ls -l ${curr_path}"/startup.sh" | awk '{print $3}'`

if [[ ${file_user} != ${os_user} ]] || [[ ${os_user} == root ]]; then
    echo "Can't run startup.sh, because it does not belong to the current user or the user is root."
    exit 1
fi

export LD_LIBRARY_PATH=$APP_HOME/lib:${LD_LIBRARY_PATH}

# update classpath
CLASSPATH=$APP_HOME/com.huawei.gauss.logicrep.jar
for f in $APP_HOME/lib/*.jar
do
    CLASSPATH=$CLASSPATH:$f
done

for f in $APP_HOME/plugin/*.jar
do
    CLASSPATH=$CLASSPATH:$f
done

for f in $APP_HOME/libext/*.jar
do
    CLASSPATH=$CLASSPATH:$f
done

for f in  $APP_HOME/lib/*.so
do
    CLASSPATH=$CLASSPATH:$f
done

if [ ! -d "$APP_HOME/log" ];then
    mkdir $APP_HOME/log
    chmod 700 $APP_HOME/log
fi
CONFPATH=$APP_HOME/conf
CLASSPATH=$CONFPATH:$JAVA_HOME/lib/tools.jar:$CLASSPATH
# set main class
MAINCLASS=com.huawei.gauss.logicrep.logicrep.ZLogCatcherMain
cmd_temp="${JAVA_HOME}/bin/java"
sequence_num="1611"

#receive parameters
JAVA_OPTS="-Xms2048m -Xmx2048m -Xmn256m -Xss1024k -XX:SurvivorRatio=8 -XX:+UseG1GC -XX:MaxGCPauseMillis=200 -XX:MaxTenuringThreshold=14 -XX:ParallelGCThreads=8 -XX:ConcGCThreads=3 -XX:+DisableExplicitGC -DlogicrepName="
cmd_temp="${cmd_temp} ${JAVA_OPTS} -classpath ${CLASSPATH} ${MAINCLASS}"

until [ $# -eq 0 ]; do
  case $1 in
  -n)
    shift
    REPNAME=$1
    JAVA_OPTS_NEW="-Xms2048m -Xmx2048m -Xmn256m -Xss1024k -XX:SurvivorRatio=8 -XX:+UseG1GC -XX:MaxGCPauseMillis=200 -XX:MaxTenuringThreshold=14 -XX:ParallelGCThreads=8 -XX:ConcGCThreads=3 -XX:+DisableExplicitGC -DlogicrepName=${REPNAME}"
    cmd_temp="${cmd_temp/${JAVA_OPTS}/${JAVA_OPTS_NEW}}"" -n $REPNAME$sequence_num"
    shift
    ;;
  -d)
    shift
    COFNAME=$1
    cmd_temp="${cmd_temp}"" -d $COFNAME"
    if [[ "$COFNAME" == /* ]]; then
      current_path=$COFNAME
    else
      current_path=$APP_HOME/$COFNAME
    fi
    cmd_temp=${cmd_temp/${CONFPATH}/${current_path}}
    shift
    ;;
  *)
    cmd_temp="${cmd_temp}"" $1"
    shift
    ;;
  esac
done

real_rep_name=$REPNAME$sequence_num
var1="$(ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}')"

if [ "$var1" != "" ];then
    echo "Can not start logicrep process,bacause the same parameter value of -n can not be used two times."
    exit 1
fi

if [ 0"$GAUSSLOG" = "0" ]; then
    if [ ! -d $APP_HOME/logicrep ];then
        mkdir -p $APP_HOME/logicrep/"${REPNAME}"/alarm
        mkdir -p $APP_HOME/logicrep/"${REPNAME}"/audit
        mkdir -p $APP_HOME/logicrep/"${REPNAME}"/perf
        mkdir -p $APP_HOME/logicrep/"${REPNAME}"/run
        mkdir -p $APP_HOME/logicrep/"${REPNAME}"/tracetable
        chmod -R 700 $APP_HOME/logicrep
    fi
else
    if [ ! -d "${GAUSSLOG}"/"${REPNAME}" ];then
        mkdir -p "${GAUSSLOG}"/"${REPNAME}"/alarm
        mkdir -p "${GAUSSLOG}"/"${REPNAME}"/audit
        mkdir -p "${GAUSSLOG}"/"${REPNAME}"/perf
        mkdir -p "${GAUSSLOG}"/"${REPNAME}"/run
        mkdir -p "${GAUSSLOG}"/"${REPNAME}"/tracetable
        chmod -R 700 "${GAUSSLOG}"/"${REPNAME}"
    fi
fi

status_file="$APP_HOME/log/$REPNAME$sequence_num.log"
if [ -f "$status_file" ]; then
    mv $status_file "$status_file.bak"
fi

touch $status_file
chmod 600 $status_file

nohup  ${cmd_temp} >>$status_file 2>&1 &

# wait for startup information
i=0
while [ $i -lt 6 ]
do
    sleep 5
    var2="$(ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}')"
    if [ "$var2" != "" ]; then
	    echo "program start successfully"
        break
    fi
    i=$(expr $i + 1)
done

var3="$(ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}')"
if [ "$var3" == "" ]; then
    echo "program start failed"
	cat $status_file
    exit 1
fi

set -e
exit 0