#!/bin/bash

# must set TOOL_ROOT LOG_FILE

# 日志文件
function get_log_file()
{
    if [[ -z ${LOG_FILE} ]]
    then
        export LOG_FILE="${MIGRATE_ROOT}/logs/${MIGRATE_MODULE_NAME}.${MIGRATE_CLASS_NAME}_${MIGRATE_STEP}_$(date '+%Y%m%d_%H%M%S').log"
    fi
    echo ${LOG_FILE}
}

# NCE迁移项进度文件
function get_progress_file()
{
    echo "${MIGRATE_ROOT}/var/plugin/ProcessDir/${MIGRATE_MODULE_NAME}.${MIGRATE_CLASS_NAME}_${MIGRATE_STEP}.txt"
}

function log()
{
	  echo "$(date '+%Y-%m-%d %H:%M:%S') | $1" >> ${LOG_FILE}
}

# 执行失败时记录日志后退出
function exit_when_occer_error()
{
    local ret=$1
    local msg=$2
    if [[ $ret -ne 0 ]]
    then
        log "execute error:${msg}"
        exit $ret
    fi
}

# 删除字符串中特殊字符，用于处理密码
function remove_special_char()
{
    local word=$(echo "$1" | sed 's/\\/\x5c\x5c\x5c\x5c/g')
    word=$(echo ${word} | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\]/\\]/g' | sed 's/\$/\\$/g' | sed 's/\:/\\:/g'| sed 's/\?/\\?/g' | sed 's/\./\\./g')
    echo $word
}

function init_python_env()
{
    # 优先取DeployAgent服务目录下软链接的python版本
    local python_home=${APP_ROOT}/rtsp/python
    local mccomon_home=${APP_ROOT}/rtsp/mccommon

    if [[ ! -d $python_home ]]
    then
      local rtsp_path=/opt/oss/rtsp
      # 在rtsp下按修改时间取最新，作为兜底措施
      python_home=$(ls -td ${rtsp_path}/python-* | head -n1)
      if [[ ! -d $python_home ]]
      then
          exit_when_occer_error 1 "python not found in ${rtsp_path}/python-*"
      fi
    fi

    if [[ ! -d $mccomon_home ]]
    then
      local rtsp_path=/opt/oss/rtsp
      mccomon_home=$(ls -td ${rtsp_path}/mccommon-* | head -n1)
      if [[ ! -d $mccomon_home ]]
      then
          exit_when_occer_error 1 "mccomon_home not found in ${rtsp_path}/mccommon-*"
      fi
    fi

    export _APP_LOG_DIR="${MIGRATE_ROOT}/logs"
    export CIPHER_ROOT="/opt/oss/manager/etc/cipher"

    export PATH=${python_home}/bin:$PATH
    export PYTHONPATH=${mccomon_home}/tools/pyscript:${mccomon_home}/tools/pyscript/cbb
    export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${python_home}/lib
}

function decrypt()
{
    local old_word=$1
    local sys_word=$(python -c "import os; os.environ['CIPHER_ROOT'] = '/opt/oss/manager/etc/cipher'; from util.ossext import Cipher;word = Cipher.decrypt('${old_word}');print(word)")
    echo ${sys_word}
}

function init_easysuit_paramters()
{
    # 判断目标是不是单管理环境
    read -t 30 -p "es_input: src_access.ip_NCE_NMS_Server_0" src_nms_server_ip
    if [[ $src_nms_server_ip =~ [0-9.]{3,} ]]
    then
        export SRC_SINGLE_MGR_NODE="true"
    else
        export SRC_SINGLE_MGR_NODE="false"
    fi
    read -t 30 -p "es_input: dst_access.ip_U2020_NMS_Server_0" dst_nms_server_ip
    if [[ $dst_nms_server_ip =~ [0-9.]{3,} ]]
    then
        export DST_SINGLE_MGR_NODE="true"
    else
        export DST_SINGLE_MGR_NODE="false"
    fi
}

# py文件不存在时获取对应pyc文件
function get_py_file()
{
    local py_file=$1
    [[ ! -f $py_file ]] && py_file="${py_file}c"
    echo ${py_file}
}

function init_kmc_version()
{
    CIPHER_MODE="kmc_v1"
    [[ -f "${OSS_ROOT}/etc/cipher/cloudsop_cipher_mode.flag" ]] && CIPHER_MODE="cloudsop"
    [[ -f "${OSS_ROOT}/etc/cipher/domain_mapping.json" ]] && CIPHER_MODE="kmc_v2"
    export CIPHER_MODE
}

function init_service_tenant_name()
{
    tenant_name=$(python -c "from uniep.utils.node import nodelist; tenant=[ten for ten in nodelist.get_all_tenants() if ten != 'manager']; print(tenant[0])")
    [[ ! -z ${tenant_name} ]] && export TENANT_NAME=${tenant_name}
}

function init_adm_user()
{
    ADM_USER=ossadm
    local machine_user=$(ps -ef | grep DNFW | grep -v grep |  awk '{print $1}' | grep admrun | head -1)
    [[ -n ${machine_user} ]] && ADM_USER=admrunuser
    export ADM_USER
}

function init_basic_env()
{
    init_adm_user
    if [[ $(whoami) == ${ADM_USER} ]]
    then
        # 为dbuser增加读写权限
        umask 0007
        chmod g+rwx ${MIGRATE_DATA_DIR}
        source /opt/oss/manager/bin/engr_profile.sh
    else
        init_easysuit_paramters
        [[ -z ${OSS_ROOT} ]] && export OSS_ROOT=/opt/oss/manager
        [[ -z ${IPMC_ROOT} ]] && export IPMC_ROOT=${OSS_ROOT}
        [[ -z ${APP_ROOT} ]] && export APP_ROOT=${OSS_ROOT}/apps/DeployAgent
        init_python_env
    fi

    init_kmc_version
    init_service_tenant_name
    export PYTHONPATH=${TOOL_ROOT}/apps:${TOOL_ROOT}:${PYTHONPATH}
}

init_basic_env