#!/bin/bash
tmp_hostname="controller-${north_netcard_ip}"
hostname=${tmp_hostname//./-}

touch hal.test
echo $# >hal.test
echo $*>>hal.test

if [[ $1 == "-north_netcard_ipv6" ]] || [[ $1 == "-north_netcard_ip" ]]; then
    for i in {1..32}
    do
        [[ ${1#-} == "north_netcard_ip" ]] && { north_netcard_ip=$2;shift 2;continue; }
        [[ ${1#-} == "north_netcard_ipv6" ]] && { north_netcard_ipv6=$2;shift 2;continue; }
        [[ ${1#-} == "south_netcard_ip" ]] && { south_netcard_ip=$2;shift 2;continue; }
        [[ ${1#-} == "south_netcard_ipv6" ]] && { south_netcard_ipv6=$2;shift 2;continue; }
        [[ ${1#-} == "internal_netcard_ip" ]] && { internal_netcard_ip=$2;shift 2;continue; }
        [[ ${1#-} == "internal_netcard_ipv6" ]] && { internal_netcard_ipv6=$2;shift 2;continue; }
        [[ ${1#-} == "second_south_netcard_ip" ]] && { second_south_netcard_ip=$2;shift 2;continue; }
        [[ ${1#-} == "second_south_netcard_ipv6" ]] && { second_south_netcard_ipv6=$2;shift 2;continue; }
        [[ ${1#-} == "north_vis_ip" ]] && { north_vis_ip=$2;shift 2;continue; }
        [[ ${1#-} == "north_vis_ipv6" ]] && { north_vis_ipv6=$2;shift 2;continue; }
        [[ ${1#-} == "south_floatip" ]] && { south_floatip=$2;shift 2;continue; }
        [[ ${1#-} == "south_float_v6ip2" ]] && { south_float_v6ip2=$2;shift 2;continue; }
        [[ ${1#-} == "second_south_float_ip" ]] && { second_south_float_ip=$2;shift 2;continue; }
        [[ ${1#-} == "south_second_v6floatip" ]] && { south_second_v6floatip=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_south_float_ip" ]] && { bgp_south_float_ip=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_internal_single" ]] && { netcard_internal_single=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_south_double" ]] && { netcard_south_double=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_internal_double" ]] && { netcard_internal_double=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_internal_triple" ]] && { netcard_internal_triple=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_south_triple" ]] && { netcard_south_triple=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_north_triple" ]] && { netcard_north_triple=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_south_netcard_single" ]] && { bgp_south_netcard_single=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_second_south_double" ]] && { netcard_second_south_double=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_south_netcard_double" ]] && { bgp_south_netcard_double=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_second_south_triple" ]] && { netcard_second_south_triple=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_south_netcard_triple" ]] && { bgp_south_netcard_triple=$2;shift 2;continue; }
        [[ ${1#-} == "north_vis_ip_mask" ]] && { north_vis_ip_mask=$2;shift 2;continue; }
        [[ ${1#-} == "north_vis_ipv6_mask" ]] && { north_vis_ipv6_mask=$2;shift 2;continue; }
        [[ ${1#-} == "south_floatip_mask2" ]] && { south_floatip_mask2=$2;shift 2;continue; }
        [[ ${1#-} == "south_floatip_v6mask2" ]] && { south_floatip_v6mask2=$2;shift 2;continue; }
        [[ ${1#-} == "second_south_float_ip_mask" ]] && { second_south_float_ip_mask=$2;shift 2;continue; }
        [[ ${1#-} == "south_second_v6floatip_mask" ]] && { south_second_v6floatip_mask=$2;shift 2;continue; }
    done
else
    internal_netcard_ip=$1
    south_netcard_ip=$2
    north_netcard_ip=$3
    north_vis_ip=$4
    south_floatip=$5
    internal_nic=$6
    south_nic=$7
    north_nic=$8
    south_mask=$9
    north_mask=${10}
    is_bgp_enable=${11}
    bgp_south_float_ip=${12}
    bgp_netcard=${13}
   if [[ ${14} == "YES" ]] || [[ ${14} == "NO" ]]; then
        bgp_node=${14}
    else
        second_south_nic=${14}
        second_south_float_ip=${15}
        second_south_netcard_ip=${16}
        second_south_mask=${17}
        bgp_node=${18}
    fi
fi


sed -i "s/user_bgp_node/${bgp_node}/g" controller.inc
sed -i "s/user_internal_nic/${internal_nic}/g" controller.inc
sed -i "s/user_south_nic/${south_nic}/g" controller.inc
sed -i "s/user_north_nic/${north_nic}/g" controller.inc
sed -i "s/user_south_mask/${south_mask}/g" controller.inc
sed -i "s/user_north_mask/${north_mask}/g" controller.inc
sed -i "s/user_is_bgp_enable/${is_bgp_enable}/g" controller.inc
sed -i "s/hostname_value/${hostname}/g" controller.inc
sed -i "s/user_bgp_netcard/${bgp_netcard}/g" controller.inc
sed -i "s/user_second_south_nic/${second_south_nic}/g" controller.inc
sed -i "s/user_second_south_mask/${second_south_mask}/g" controller.inc


sed -i "s/user_north_netcard_ip/${north_netcard_ip}/g" controller.inc
sed -i "s/user_north_netcard_v6ip/${north_netcard_ipv6}/g" controller.inc
sed -i "s/user_south_netcard_ip/${south_netcard_ip}/g" controller.inc
sed -i "s/user_south_netcard_v6ip/${south_netcard_ipv6}/g" controller.inc
sed -i "s/user_internal_netcard_ip/${internal_netcard_ip}/g" controller.inc
sed -i "s/user_internal_netcard_v6ip/${internal_netcard_ipv6}/g" controller.inc
sed -i "s/user_second_south_netcard_ip/${second_south_netcard_ip}/g" controller.inc
sed -i "s/user_second_south_netcard_v6ip/${second_south_netcard_ipv6}/g" controller.inc
sed -i "s/user_north_vis_ip/${north_vis_ip}/g" controller.inc
sed -i "s/user_north_vis_v6ip/${north_vis_ipv6}/g" controller.inc
sed -i "s/user_south_floatip/${south_floatip}/g" controller.inc
sed -i "s/user_south_float_v6ip2/${south_float_v6ip2}/g" controller.inc
sed -i "s/user_second_south_float_ip/${second_south_float_ip}/g" controller.inc
sed -i "s/user_south_second_v6floatip/${south_second_v6floatip}/g" controller.inc
sed -i "s/user_bgp_south_float_ip/${bgp_south_float_ip}/g" controller.inc
sed -i "s/user_netcard_internal_single/${netcard_internal_single}/g" controller.inc
sed -i "s/user_netcard_south_double/${netcard_south_double}/g" controller.inc
sed -i "s/user_netcard_internal_double/${netcard_internal_double}/g" controller.inc
sed -i "s/user_netcard_internal_triple/${netcard_internal_triple}/g" controller.inc
sed -i "s/user_netcard_south_triple/${netcard_south_triple}/g" controller.inc
sed -i "s/user_netcard_north_triple/${netcard_north_triple}/g" controller.inc
sed -i "s/user_bgp_south_netcard_single/${bgp_south_netcard_single}/g" controller.inc
sed -i "s/user_netcard_second_south_double/${netcard_second_south_double}/g" controller.inc
sed -i "s/user_bgp_south_netcard_double/${bgp_south_netcard_double}/g" controller.inc
sed -i "s/user_netcard_second_south_triple/${netcard_second_south_triple}/g" controller.inc
sed -i "s/user_bgp_south_netcard_triple/${bgp_south_netcard_triple}/g" controller.inc
sed -i "s/user_north_visip_mask/${north_vis_ip_mask}/g" controller.inc
sed -i "s/user_north_visipv6_mask/${north_vis_ipv6_mask}/g" controller.inc
sed -i "s/user_south_float_ip_mask2/${south_floatip_mask2}/g" controller.inc
sed -i "s/user_south_float_ip_v6mask2/${south_floatip_v6mask2}/g" controller.inc
sed -i "s/user_second_south_floatip_mask/${second_south_float_ip_mask}/g" controller.inc
sed -i "s/user_south_second_v6float_mask/${south_second_v6floatip_mask}/g" controller.inc