#!/bin/bash
tmp_hostname="controller-${north_netcard_ip}"
hostname=${tmp_hostname//./-}

touch hal.test
echo $# >hal.test
echo $*>>hal.test

if [[ $1 == "-cpu_type" ]] ; then
    for i in {1..57}
    do
        [[ ${1#-} == "cpu_type" ]] && { cpu_type=$2;shift 2;continue; }
        [[ ${1#-} == "plane" ]] && { plane=$2;shift 2;continue; }
        [[ ${1#-} == "install_nodes" ]] && { install_nodes=$2;shift 2;continue; }
        [[ ${1#-} == "north_stack_mode" ]] && { north_stack_mode=$2;shift 2;continue; }
        [[ ${1#-} == "south_stack_mode" ]] && { south_stack_mode=$2;shift 2;continue; }
        [[ ${1#-} == "internal_stack_mode" ]] && { internal_stack_mode=$2;shift 2;continue; }
        [[ ${1#-} == "double_south" ]] && { double_south=$2;shift 2;continue; }
        [[ ${1#-} == "upload_package" ]] && { upload_package=$2;shift 2;continue; }
        [[ ${1#-} == "is_bgp_enable" ]] && { is_bgp_enable=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_stack_mode" ]] && { bgp_stack_mode=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_south_same_netcard" ]] && { bgp_south_same_netcard=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_north" ]] && { netcard_north=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_north_bond_toggle" ]] && { netcard_north_bond_toggle=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_north_first" ]] && { netcard_north_first=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_north_second" ]] && { netcard_north_second=$2;shift 2;continue; }
        [[ ${1#-} == "network_north_mask" ]] && { network_north_mask=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_south" ]] && { netcard_south=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_south_bond_toggle" ]] && { netcard_south_bond_toggle=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_south_first" ]] && { netcard_south_first=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_south_second" ]] && { netcard_south_second=$2;shift 2;continue; }
        [[ ${1#-} == "network_south_mask" ]] && { network_south_mask=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_internal" ]] && { netcard_internal=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_internal_bond_toggle" ]] && { netcard_internal_bond_toggle=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_internal_first" ]] && { netcard_internal_first=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_internal_second" ]] && { netcard_internal_second=$2;shift 2;continue; }
        [[ ${1#-} == "network_internal_mask" ]] && { network_internal_mask=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_second_south" ]] && { netcard_second_south=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_second_south_bond_toggle" ]] && { netcard_second_south_bond_toggle=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_second_south_first" ]] && { netcard_second_south_first=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_second_south_second" ]] && { netcard_second_south_second=$2;shift 2;continue; }
        [[ ${1#-} == "network_second_south_mask" ]] && { network_second_south_mask=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_south_netcard" ]] && { bgp_south_netcard=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_bgp_south_bond_toggle" ]] && { netcard_bgp_south_bond_toggle=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_bgp_south_first" ]] && { netcard_bgp_south_first=$2;shift 2;continue; }
        [[ ${1#-} == "netcard_bgp_south_second" ]] && { netcard_bgp_south_second=$2;shift 2;continue; }
        [[ ${1#-} == "network_bgp_south_mask" ]] && { network_bgp_south_mask=$2;shift 2;continue; }
        [[ ${1#-} == "north_vis_ip" ]] && { north_vis_ip=$2;shift 2;continue; }
        [[ ${1#-} == "south_floatip2" ]] && { south_floatip2=$2;shift 2;continue; }
        [[ ${1#-} == "second_south_float_ip" ]] && { second_south_float_ip=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_south_float_ip" ]] && { bgp_south_float_ip=$2;shift 2;continue; }
        [[ ${1#-} == "north_vis_ipv6" ]] && { north_vis_ipv6=$2;shift 2;continue; }
        [[ ${1#-} == "south_float_v6ip2" ]] && { south_float_v6ip2=$2;shift 2;continue; }
        [[ ${1#-} == "south_second_v6floatip" ]] && { south_second_v6floatip=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_south_float_v6ip" ]] && { bgp_south_float_v6ip=$2;shift 2;continue; }
        [[ ${1#-} == "north_netcard_ip" ]] && { north_netcard_ip=$2;shift 2;continue; }
        [[ ${1#-} == "south_netcard_ip" ]] && { south_netcard_ip=$2;shift 2;continue; }
        [[ ${1#-} == "internal_netcard_ip" ]] && { internal_netcard_ip=$2;shift 2;continue; }
        [[ ${1#-} == "second_south_netcard_ip" ]] && { second_south_netcard_ip=$2;shift 2;continue; }
        [[ ${1#-} == "bgp_south_netcard_ip" ]] && { bgp_south_netcard_ip=$2;shift 2;continue; }
        [[ ${1#-} == "easysuite_ip" ]] && { easysuite_ip=$2;shift 2;continue; }
        [[ ${1#-} == "node_1_ip" ]] && { node_1_ip=$2;shift 2;continue; }
        [[ ${1#-} == "node_2_ip" ]] && { node_2_ip=$2;shift 2;continue; }
        [[ ${1#-} == "node_3_ip" ]] && { node_3_ip=$2;shift 2;continue; }
        [[ ${1#-} == "node_2_uname" ]] && { node_2_uname=$2;shift 2;continue; }
        [[ ${1#-} == "node_3_uname" ]] && { node_3_uname=$2;shift 2;continue; }
    done
fi

#base config
sed -i "s/user_cpu_type/${cpu_type}/g" controller_bond.inc
sed -i "s/user_plane/${plane}/g" controller_bond.inc
sed -i "s/user_install_nodes/${install_nodes}/g" controller_bond.inc
sed -i "s/user_north_stack_mode/${north_stack_mode}/g" controller_bond.inc
sed -i "s/user_south_stack_mode/${south_stack_mode}/g" controller_bond.inc
sed -i "s/user_internal_stack_mode/${internal_stack_mode}/g" controller_bond.inc
sed -i "s/user_is_bgp_enable/${is_bgp_enable}/g" controller_bond.inc
sed -i "s/user_bgp_stack_mode/${bgp_stack_mode}/g" controller_bond.inc
sed -i "s/user_bgp_south_same_netcard/${bgp_south_same_netcard}/g" controller_bond.inc
sed -i "s/user_double_south/${double_south}/g" controller_bond.inc
sed -i "s/user_upload_package/${upload_package}/g" controller_bond.inc
sed -i "s/user_easysuite_ip/${easysuite_ip}/g" controller_bond.inc
sed -i "s/user_node_1_ip/${node_1_ip}/g" controller_bond.inc
sed -i "s/user_node_2_ip/${node_2_ip}/g" controller_bond.inc
sed -i "s/user_node_3_ip/${node_3_ip}/g" controller_bond.inc
sed -i "s/user_node_2_uname/${node_2_uname}/g" controller_bond.inc
sed -i "s/user_node_3_uname/${node_3_uname}/g" controller_bond.inc

#user bond config
sed -i "s/user_netcard_north_bond_toggle/${netcard_north_bond_toggle}/g" controller_bond.inc
sed -i "s/user_netcard_north_first/${netcard_north_first}/g" controller_bond.inc
sed -i "s/user_netcard_north_second/${netcard_north_second}/g" controller_bond.inc
sed -i "s/user_network_north_mask/${network_north_mask}/g" controller_bond.inc
sed -i "s/user_netcard_north/${netcard_north}/g" controller_bond.inc

sed -i "s/user_netcard_south_bond_toggle/${netcard_south_bond_toggle}/g" controller_bond.inc
sed -i "s/user_netcard_south_first/${netcard_south_first}/g" controller_bond.inc
sed -i "s/user_netcard_south_second/${netcard_south_second}/g" controller_bond.inc
sed -i "s/user_network_south_mask/${network_south_mask}/g" controller_bond.inc
sed -i "s/user_netcard_south/${netcard_south}/g" controller_bond.inc

sed -i "s/user_netcard_internal_bond_toggle/${netcard_internal_bond_toggle}/g" controller_bond.inc
sed -i "s/user_netcard_internal_first/${netcard_internal_first}/g" controller_bond.inc
sed -i "s/user_netcard_internal_second/${netcard_internal_second}/g" controller_bond.inc
sed -i "s/user_network_internal_mask/${network_internal_mask}/g" controller_bond.inc
sed -i "s/user_netcard_internal/${netcard_internal}/g" controller_bond.inc

sed -i "s/user_netcard_second_south_bond_toggle/${netcard_second_south_bond_toggle}/g" controller_bond.inc
sed -i "s/user_netcard_second_south_first/${netcard_second_south_first}/g" controller_bond.inc
sed -i "s/user_netcard_second_south_second/${netcard_second_south_second}/g" controller_bond.inc
sed -i "s/user_network_second_south_mask/${network_second_south_mask}/g" controller_bond.inc
sed -i "s/user_netcard_second_south/${netcard_second_south}/g" controller_bond.inc

sed -i "s/user_netcard_bgp_south_bond_toggle/${netcard_bgp_south_bond_toggle}/g" controller_bond.inc
sed -i "s/user_netcard_bgp_south_first/${netcard_bgp_south_first}/g" controller_bond.inc
sed -i "s/user_netcard_bgp_south_second/${netcard_bgp_south_second}/g" controller_bond.inc
sed -i "s/user_network_bgp_south_mask/${network_bgp_south_mask}/g" controller_bond.inc
sed -i "s/user_bgp_south_netcard/${bgp_south_netcard}/g" controller_bond.inc

#user floating ip config
sed -i "s/user_north_vis_ip/${north_vis_ip}/g" controller_bond.inc
sed -i "s/user_south_floatip2/${south_floatip2}/g" controller_bond.inc
sed -i "s/user_second_south_float_ip/${second_south_float_ip}/g" controller_bond.inc
sed -i "s/user_bgp_south_float_ip/${bgp_south_float_ip}/g" controller_bond.inc

sed -i "s/user_north_vis_v6ip/${north_vis_ipv6}/g" controller_bond.inc
sed -i "s/user_south_float_v6ip2/${south_float_v6ip2}/g" controller_bond.inc
sed -i "s/user_south_second_v6floatip/${south_second_v6floatip}/g" controller_bond.inc
sed -i "s/user_bgp_south_float_v6ip/${bgp_south_float_v6ip}/g" controller_bond.inc

#node ip config
sed -i "s/user_node_north_netcard_ip/${north_netcard_ip}/g" controller_bond.inc
sed -i "s/user_node_south_netcard_ip/${south_netcard_ip}/g" controller_bond.inc
sed -i "s/user_node_internal_netcard_ip/${internal_netcard_ip}/g" controller_bond.inc
sed -i "s/user_node_second_south_netcard_ip/${second_south_netcard_ip}/g" controller_bond.inc
sed -i "s/user_node_bgp_south_netcard_ip/${bgp_south_netcard_ip}/g" controller_bond.inc
