-- 去除索引
alter table TAB_SECM_TRAFFIC_POLICY drop CONSTRAINT UNIQUE_TRAFFIC_POLICY_NAME_ADOM;
-- 迁移开关
insert into TAB_SECM_MIGRATE_SWITCH(ID, TYPE, VALUE, CREATE_TIME) VALUES('c2b040ae-8f37-486c-a697-ca9e758e7849', 'policy_trans', 'policy_trans', now());
-- natserver开关
insert into TAB_SECM_MIGRATE_SWITCH(ID, TYPE, VALUE, CREATE_TIME) VALUES('6d06bea2-ee61-4184-a6cc-5afceb03b84f', 'natserver_migrate', 'natserver_migrate', now());
-- 带宽迁移开关
insert into TAB_SECM_MIGRATE_SWITCH(ID, TYPE, VALUE, CREATE_TIME) VALUES('0909f01e-1e89-4cb3-8253-5457897fdc4d', 'traffic_migrate', 'traffic_migrate', now());


-- 带宽通道
insert into
	TAB_SECM_TRAFFIC_PROFILE
	(PKID, NAME, ADOM_ID, SOURCE, LIMIT_MODE, REFERENCE_MODE, LIMIT_OBJECT, SERVICE_ID, GLOBAL_MAX_CONNECTION, GLOBAL_MAX_UPSTREAM_BANDWIDTH, GLOBAL_MAX_DOWNSTREAM_BANDWIDTH)
	SELECT ID AS PKID, NAME, TENANT_ID AS ADOM_ID, 'admin-service' as SOURCE, 'updown' as LIMIT_MODE, 'exclusive' as REFERENCE_MODE,	
    'per-ip' as LIMIT_OBJECT, ID as SERVICE_ID, CONNECTION_LIMIT AS GLOBAL_MAX_CONNECTION, TX_PEAK_LIMIT AS GLOBAL_MAX_UPSTREAM_BANDWIDTH,
	RX_PEAK_LIMIT AS GLOBAL_MAX_DOWNSTREAM_BANDWIDTH
	FROM
		tab_secm_svo_qos_l4l7;
				

-- 带宽策略
insert into
	TAB_SECM_TRAFFIC_POLICY
	(PKID, NAME, SOURCE, ADOM_ID, DESCRIPTION, ACTION, RULE_ORDER, DEPLOY_STATUS, UNIQUE_CODE, LOCKED,
	ENABLE_STATE, CREATE_TIME, LAST_UPD_TIME_EXCEPT_DEV, LAST_UPD_TIME, SOURCE_TYPE, DEST_TYPE, SERVICE_ID, CREATE_BY)
	-- 字段与上面一致，部分字段设置默认值
	SELECT t.ID AS PKID, t.NAME, 'admin-service' as SOURCE, d.TENANT_ID AS ADOM_ID, t.DESCRIPTION, 
	CASE WHEN t.traffic_profile IS NOT NULL THEN 'true' ELSE 'false' END AS ACTION, t.RULE_ORDER, 
	'0' AS DEPLOY_STATUS, '0' AS UNIQUE_CODE, 0 AS LOCKED,
	CASE t.ENABLE WHEN 1 THEN 1 ELSE 0 END AS ENABLE_STATE,
	unix_timestamp(t.CREATETIME) * 1000 AS CREATE_TIME,				-- unxi_timestamp：秒级
	unix_timestamp(t.CREATETIME) * 1000 AS LAST_UPD_TIME_EXCEPT_DEV,
	CASE WHEN t.UPDATETIME IS NOT NULL THEN unix_timestamp(t.UPDATETIME) * 1000 ELSE unix_timestamp(t.CREATETIME) * 1000 END AS LAST_UPD_TIME,	
	CASE WHEN t.SOURCE_ZONE IS NOT NULL  THEN 'sourceZone' END AS SOURCE_TYPE,
	CASE WHEN t.DESTINATION_ZONE IS NOT NULL THEN 'destinationZone' END AS DEST_TYPE, 
	t.ID AS SERVICE_ID,
	'' AS CREATE_BY
	FROM
		tab_secm_vas_dal_trafficpolicy t, TAB_SECM_LOGIC_VAS d 
		where t.NODE_ID = d.NE_GROUP_ID AND t.VSYS_NAME = d.VSYSNAME;
	
			
		
-- 带宽策略与带宽通道绑定关系
insert into 	
	TAB_SECM_TRAFFIC_POLICY_RELATION_OBJECT
	(PKID, POLICY_ID, OBJECT_ID, OBJECT_TYPE, ADOM_ID, OBJECT_NAME)
	
	(
		SELECT sys_guid() AS PKID, t.ID AS POLICY_ID, q.Id AS OBJECT_ID, 'TRAFFIC_PROFILE' as OBJECT_TYPE, q.TENANT_ID AS ADOM_ID, q.NAME AS OBJECT_NAME
		FROM tab_secm_vas_dal_trafficpolicy t, tab_secm_svo_qos_l4l7 q, TAB_SECM_SECURECENTER_DEVICE d 
		where t.traffic_profile = q.name and t.NODE_ID = d.PARENTDN AND t.VSYS_NAME = d.NAME AND q.TENANT_ID = d.TENANT_ID AND t.traffic_profile is not null
	)
;


-- 策略跟设备关联关系
insert into
	TAB_SECM_TRAFFIC_POLICY_RELATION_DEVICE
	(PKID, OBJECT_ID, OBJECT_TYPE, DEVICE_DN, DEVICE_TYPE, DEVICE_NAME, CREATE_TIME, ADOM_ID, CHANGE_STATUS, DEPLOY_STATUS)
	(
		select sys_guid() AS PKID, t.ID AS OBJECT_ID, 0 AS OBJECT_TYPE, d.ID AS DEVICE_DN, 0 as DEVICE_TYPE, d.NAME AS DEVICE_NAME,
            unix_timestamp(t.CREATETIME) * 1000 AS CREAT_TIME, d.ADOM_ID, 0 AS CHANGE_STATUS, 0 AS DEPLOY_STATUS 
        from tab_secm_vas_dal_trafficpolicy t, TAB_SECM_SECURECENTER_DEVICE d 
        where t.NODE_ID = d.PARENTDN AND t.VSYS_NAME = d.NAME
	);
		
	
insert into
	TAB_SECM_TRAFFIC_POLICY_RELATION_SUB_DEVICE
	(PKID, OBJECT_ID, DEVICE_GROUP_ID, DEVICE_DN, CHANGE_STATUS, DEPLOY_STATUS, IS_DELETED, OBJECT_TYPE)
	(
		select sys_guid() AS PKID, t.ID AS OBJECT_ID, d.GROUP_ID AS DEVICE_GROUP_ID, d.ID AS DEVICE_DN, 
          0 AS CHANGE_STATUS, 0 AS DEPLOY_STATUS, false AS IS_DELETED, 0 AS OBJECT_TYPE 
        from tab_secm_vas_dal_trafficpolicy t, TAB_SECM_SECURECENTER_DEVICE d 
        where t.NODE_ID = d.PARENTDN AND t.VSYS_NAME = d.NAME
	);

commit;