#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_scripts_dir=/opt/upgrade/easysuite_upgrade/scripts/iMasterNCE-Fabric
log_dir=`sh ${upgrade_scripts_dir}/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main()
{
    . /opt/oss/manager/agent/bin/engr_profile.sh
    tenant_name=$(${PYTHONHOME}/bin/python ${upgrade_scripts_dir}/pyscripts/get_info.py ${2}/plandata.json "productname")
    result=$?
    if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get tenant name successfully: ${tenant_name}"  >> ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get tenant name failed: ${tenant_name}" >> ${log_file}
            exit 1
    fi

    upgrade_path=$(${PYTHONHOME}/bin/python ${upgrade_scripts_dir}/pyscripts/get_upgrade_path.py ${2}/plandata.json)
    result=$?
    if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get upgrade path successfully: ${upgrade_path}" >> ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get upgrade path failed: ${upgrade_path}" >> ${log_file}
            exit 1
    fi

    # 调用python，执行具体步骤
    cd ${upgrade_scripts_dir}
    py_result=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import read_config;print(read_config.main('${upgrade_path}', '${tenant_name}', '${log_file}', 'data_migrate'))")
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the result is:"  >> ${log_file}
    echo "$py_result"  >> ${log_file}
    echo "$py_result" 1>&2

    # 处理结果
    result_code=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python ${upgrade_scripts_dir}/pyscripts/get_result_code.py "$py_result")
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the result_code is: ${result_code}"  >> ${log_file}
    if [[ ${result_code} == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${self_name} has been executed successfully."  >> ${log_file}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${self_name} has been executed failed."  >> ${log_file}
        exit 1
    fi
}

main $@
