-- 1.去除索引
alter table TAB_SECM_TRAFFIC_POLICY drop CONSTRAINT UNIQUE_TRAFFIC_POLICY_NAME_ADOM;
-- 2.带宽策略迁移开关
insert into TAB_SECM_MIGRATE_SWITCH(ID, TYPE, VALUE, CREATE_TIME) VALUES('c2b040ae-8f37-486c-a697-ca9e758e7849', 'policy_trans', 'policy_trans', now());
-- 3.平台数据迁移开关
insert into TAB_SECM_MIGRATE_SWITCH(ID, TYPE, VALUE, CREATE_TIME) VALUES('012345ff-ffff-ffff-ffff-ffffffffffff', 'plat_migrate', 'plat_migrate', now());

--4.静态路由新增部署表，将配置表中的数据迁移到部署表，设备为主备的时候需要考虑将NE_GROUP_ID转换为NE_ID
DECLARE
  ROUTE_CURSOR           SYS_REFCURSOR;
  V_NE_ID                TAB_SECM_SECURECENTER_DEVICE.ID % TYPE;
  V_VSYS_NAME            TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.VSYS_NAME % TYPE;
  V_DESTINATION_PREFIX   TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.DESTINATION_PREFIX % TYPE;
  V_NEXT_HOP_ADDRESS     TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.NEXT_HOP_ADDRESS % TYPE;
  V_OUTGOING_INTERFACE   TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.OUTGOING_INTERFACE % TYPE;
  V_PREFERENCE           TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.PREFERENCE % TYPE;
  V_TRACK_IPLINK_NAME    TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.TRACK_IPLINK_NAME % TYPE;
  V_DEST_VSYS            TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.DEST_VSYS % TYPE;
  V_CREATETIME           TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.CREATETIME % TYPE;
  V_UPDATETIME           TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.UPDATETIME % TYPE;
  V_SOURCE               TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC.SOURCE % TYPE;
  V_UUID                 VARCHAR(64);
BEGIN
  OPEN ROUTE_CURSOR
  FOR SELECT D.ID, R.VSYS_NAME, R.DESTINATION_PREFIX, R.NEXT_HOP_ADDRESS, R.OUTGOING_INTERFACE, R.PREFERENCE, R.TRACK_IPLINK_NAME, R.DEST_VSYS, R.CREATETIME, R.UPDATETIME, R.SOURCE 
  FROM TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC R 
  CROSS JOIN TAB_SECM_SECURECENTER_DEVICE D 
  WHERE R.NODE_ID = D.GROUP_ID 
  AND D.VIRTUAL = 0 
  AND D.GROUP_TYPE != 'backup'; LOOP
    FETCH ROUTE_CURSOR INTO V_NE_ID,V_VSYS_NAME,V_DESTINATION_PREFIX,V_NEXT_HOP_ADDRESS,V_OUTGOING_INTERFACE,V_PREFERENCE,V_TRACK_IPLINK_NAME,V_DEST_VSYS,V_CREATETIME,V_UPDATETIME,V_SOURCE;
    EXIT WHEN ROUTE_CURSOR%NOTFOUND;
      V_UUID := LOWER(UUID);
      V_UUID := SUBSTRING(V_UUID FROM 1 
      FOR 8)||'-'||SUBSTRING(V_UUID FROM 9 FOR 4)||'-'||SUBSTRING(V_UUID FROM 13 FOR 4)||'-'||SUBSTRING(V_UUID FROM 17 FOR 4)||'-'||SUBSTRING(V_UUID FROM 21 FOR 12);
      INSERT INTO TAB_SECM_VAS_DAL_L4L7_ROUTESTATIC_DEPLOY
        (ID, NE_ID, VSYS_NAME, DESTINATION_PREFIX, NEXT_HOP_ADDRESS, OUTGOING_INTERFACE, PREFERENCE, TRACK_IPLINK_NAME, DEST_VSYS, CREATETIME, UPDATETIME, SOURCE)
      VALUES
        (V_UUID, V_NE_ID, V_VSYS_NAME, V_DESTINATION_PREFIX, V_NEXT_HOP_ADDRESS, V_OUTGOING_INTERFACE, V_PREFERENCE, V_TRACK_IPLINK_NAME, V_DEST_VSYS, V_CREATETIME, V_UPDATETIME, V_SOURCE);
  END LOOP;
  CLOSE ROUTE_CURSOR;
END;
/

-- 5.带宽通道
insert into
	TAB_SECM_TRAFFIC_PROFILE
	(PKID, NAME, ADOM_ID, SOURCE, LIMIT_MODE, REFERENCE_MODE, LIMIT_OBJECT, SERVICE_ID, GLOBAL_MAX_CONNECTION, GLOBAL_MAX_UPSTREAM_BANDWIDTH, GLOBAL_MAX_DOWNSTREAM_BANDWIDTH)
	SELECT ID AS PKID, NAME, TENANT_ID AS ADOM_ID, 'admin-service' as SOURCE, 'updown' as LIMIT_MODE, 'exclusive' as REFERENCE_MODE,	
    'per-ip' as LIMIT_OBJECT, ID as SERVICE_ID, CONNECTION_LIMIT AS GLOBAL_MAX_CONNECTION, TX_PEAK_LIMIT AS GLOBAL_MAX_UPSTREAM_BANDWIDTH,
	RX_PEAK_LIMIT AS GLOBAL_MAX_DOWNSTREAM_BANDWIDTH
	FROM
		tab_secm_svo_qos_l4l7;
				

-- 6.带宽策略
insert into
	TAB_SECM_TRAFFIC_POLICY
	(PKID, NAME, SOURCE, ADOM_ID, DESCRIPTION, ACTION, RULE_ORDER, DEPLOY_STATUS, UNIQUE_CODE, LOCKED,
	ENABLE_STATE, CREATE_TIME, LAST_UPD_TIME_EXCEPT_DEV, LAST_UPD_TIME, SOURCE_TYPE, DEST_TYPE, SERVICE_ID, CREATE_BY)
	-- 字段与上面一致，部分字段设置默认值
	SELECT t.ID AS PKID, t.NAME, 'admin-service' as SOURCE, d.TENANT_ID AS ADOM_ID, t.DESCRIPTION, 
	CASE WHEN t.traffic_profile IS NOT NULL THEN 'true' ELSE 'false' END AS ACTION, t.RULE_ORDER, 
	'0' AS DEPLOY_STATUS, '0' AS UNIQUE_CODE, 0 AS LOCKED,
	CASE t.ENABLE WHEN 1 THEN 1 ELSE 0 END AS ENABLE_STATE,
	unix_timestamp(t.CREATETIME) * 1000 AS CREATE_TIME,				-- unxi_timestamp：秒级
	unix_timestamp(t.CREATETIME) * 1000 AS LAST_UPD_TIME_EXCEPT_DEV,
	CASE WHEN t.UPDATETIME IS NOT NULL THEN unix_timestamp(t.UPDATETIME) * 1000 ELSE unix_timestamp(t.CREATETIME) * 1000 END AS LAST_UPD_TIME,	
	CASE WHEN t.SOURCE_ZONE IS NOT NULL  THEN 'sourceZone' END AS SOURCE_TYPE,
	CASE WHEN t.DESTINATION_ZONE IS NOT NULL THEN 'destinationZone' END AS DEST_TYPE, 
	t.ID AS SERVICE_ID,
	'' AS CREATE_BY
	FROM
		tab_secm_vas_dal_trafficpolicy t, TAB_SECM_LOGIC_VAS d 
		where t.NODE_ID = d.NE_GROUP_ID AND t.VSYS_NAME = d.VSYSNAME;
	
			
		
-- 7.带宽策略与带宽通道绑定关系
insert into 	
	TAB_SECM_TRAFFIC_POLICY_RELATION_OBJECT
	(PKID, POLICY_ID, OBJECT_ID, OBJECT_TYPE, ADOM_ID, OBJECT_NAME)
	
	(
		SELECT sys_guid() AS PKID, t.ID AS POLICY_ID, q.Id AS OBJECT_ID, 'TRAFFIC_PROFILE' as OBJECT_TYPE, q.TENANT_ID AS ADOM_ID, q.NAME AS OBJECT_NAME
		FROM tab_secm_vas_dal_trafficpolicy t, tab_secm_svo_qos_l4l7 q, TAB_SECM_SECURECENTER_DEVICE d 
		where t.traffic_profile = q.name and t.NODE_ID = d.PARENTDN AND t.VSYS_NAME = d.NAME AND q.TENANT_ID = d.TENANT_ID AND t.traffic_profile is not null
	)
;


-- 8.策略跟设备关联关系
insert into
	TAB_SECM_TRAFFIC_POLICY_RELATION_DEVICE
	(PKID, OBJECT_ID, OBJECT_TYPE, DEVICE_DN, DEVICE_TYPE, DEVICE_NAME, CREATE_TIME, ADOM_ID, CHANGE_STATUS, DEPLOY_STATUS)
	(
		select sys_guid() AS PKID, t.ID AS OBJECT_ID, 0 AS OBJECT_TYPE, d.ID AS DEVICE_DN, 0 as DEVICE_TYPE, d.NAME AS DEVICE_NAME,
            unix_timestamp(t.CREATETIME) * 1000 AS CREAT_TIME, d.ADOM_ID, 0 AS CHANGE_STATUS, 0 AS DEPLOY_STATUS 
        from tab_secm_vas_dal_trafficpolicy t, TAB_SECM_SECURECENTER_DEVICE d 
        where t.NODE_ID = d.PARENTDN AND t.VSYS_NAME = d.NAME
	);
		
	
insert into
	TAB_SECM_TRAFFIC_POLICY_RELATION_SUB_DEVICE
	(PKID, OBJECT_ID, DEVICE_GROUP_ID, DEVICE_DN, CHANGE_STATUS, DEPLOY_STATUS, IS_DELETED, OBJECT_TYPE)
	(
		select sys_guid() AS PKID, t.ID AS OBJECT_ID, d.GROUP_ID AS DEVICE_GROUP_ID, d.ID AS DEVICE_DN, 
          0 AS CHANGE_STATUS, 0 AS DEPLOY_STATUS, false AS IS_DELETED, 0 AS OBJECT_TYPE 
        from tab_secm_vas_dal_trafficpolicy t, TAB_SECM_SECURECENTER_DEVICE d 
        where t.NODE_ID = d.PARENTDN AND t.VSYS_NAME = d.NAME
	);

commit;

--9.资源池配额中安全策略由policy_name改成policy_id
update tab_secm_common_resource_item r set r.service_id = (select pkid from TAB_SECM_SECURITY_POLICY p where r.service_id = p.policy_name) where exists (select 1 from TAB_SECM_SECURITY_POLICY p where r.service_id = p.policy_name);

--10.LOG_SRC_IP默认取值与Device_ip一致
update tab_secm_securecenter_device set log_src_ip = ip;

--11.vsys关联关系
DECLARE
  VSYS_CURSOR         SYS_REFCURSOR;
  V_VSYS_ID           TAB_SECM_SECURECENTER_VSYS.ID % TYPE;
  V_NE_ID             TAB_SECM_SECURECENTER_VSYS.NE_ID % TYPE;
  V_INTERFACES        TAB_SECM_SECURECENTER_VSYS.INTERFACES % TYPE;
  V_PUBLIC_INTERFACES TAB_SECM_SECURECENTER_VSYS.PUBLIC_INTERFACES % TYPE;
  V_IMPORT_FLOWS      TAB_SECM_SECURECENTER_VSYS.IMPORT_FLOWS % TYPE;
  V_UUID              VARCHAR(64);
  V_OBJECT_NAME       VARCHAR(512);
  COMMA_CUR_INDEX     NUMBER;
  COMMA_NEXT_INDEX    NUMBER;
BEGIN
  OPEN            VSYS_CURSOR
  FOR SELECT ID, NE_ID, INTERFACES, PUBLIC_INTERFACES, IMPORT_FLOWS FROM TAB_SECM_SECURECENTER_VSYS; LOOP
    FETCH VSYS_CURSOR INTO V_VSYS_ID,V_NE_ID,V_INTERFACES,V_PUBLIC_INTERFACES,V_IMPORT_FLOWS;
    EXIT WHEN VSYS_CURSOR%NOTFOUND;
    COMMA_CUR_INDEX  := 1;
    COMMA_NEXT_INDEX := 1;
    WHILE COMMA_NEXT_INDEX > 0 LOOP
      COMMA_NEXT_INDEX := LOCATE(',', V_INTERFACES, COMMA_CUR_INDEX);
      IF COMMA_CUR_INDEX = COMMA_NEXT_INDEX THEN
        COMMA_CUR_INDEX := COMMA_CUR_INDEX + 1;
        CONTINUE;
      END IF;
      IF COMMA_NEXT_INDEX > 0 THEN
        V_OBJECT_NAME   := SUBSTRING(V_INTERFACES, COMMA_CUR_INDEX, COMMA_NEXT_INDEX - COMMA_CUR_INDEX);
        COMMA_CUR_INDEX := COMMA_NEXT_INDEX + 1;
      ELSE
        V_OBJECT_NAME := SUBSTRING(V_INTERFACES, COMMA_CUR_INDEX);
      END IF;
      IF (V_OBJECT_NAME IS NOT NULL AND TRIM(V_OBJECT_NAME) != '') THEN
        V_UUID := LOWER(UUID);
        V_UUID := SUBSTRING(V_UUID FROM 1 
        FOR 8)||'-'||SUBSTRING(V_UUID FROM 9 FOR 4)||'-'||SUBSTRING(V_UUID FROM 13 FOR 4)||'-'||SUBSTRING(V_UUID FROM 17 FOR 4)||'-'||SUBSTRING(V_UUID FROM 21 FOR 12);
        INSERT INTO TAB_SECM_SECURECENTER_VSYS_RELATED_OBJECT
          (ID, NE_ID, VSYS_ID, OBJECT_TYPE, OBJECT_NAME)
        VALUES
          (V_UUID, V_NE_ID, V_VSYS_ID, 'INTERFACE', V_OBJECT_NAME);
      END IF;
    END LOOP;
    COMMA_CUR_INDEX  := 1;
    COMMA_NEXT_INDEX := 1;
    WHILE COMMA_NEXT_INDEX > 0 LOOP
      COMMA_NEXT_INDEX := LOCATE(',', V_PUBLIC_INTERFACES, COMMA_CUR_INDEX);
      IF COMMA_CUR_INDEX = COMMA_NEXT_INDEX THEN
        COMMA_CUR_INDEX := COMMA_CUR_INDEX + 1;
        CONTINUE;
      END IF;
      IF COMMA_NEXT_INDEX > 0 THEN
        V_OBJECT_NAME   :=  SUBSTRING(V_PUBLIC_INTERFACES, COMMA_CUR_INDEX, COMMA_NEXT_INDEX - COMMA_CUR_INDEX);
        COMMA_CUR_INDEX := COMMA_NEXT_INDEX + 1;
      ELSE
        V_OBJECT_NAME :=  SUBSTRING(V_PUBLIC_INTERFACES, COMMA_CUR_INDEX);
      END IF;
      IF (V_OBJECT_NAME IS NOT NULL AND TRIM(V_OBJECT_NAME) != '') THEN
        V_UUID := LOWER(UUID);
        V_UUID := SUBSTRING(V_UUID FROM 1 
        FOR 8)||'-'||SUBSTRING(V_UUID FROM 9 FOR 4)||'-'||SUBSTRING(V_UUID FROM 13 FOR 4)||'-'||SUBSTRING(V_UUID FROM 17 FOR 4)||'-'||SUBSTRING(V_UUID FROM 21 FOR 12);
        INSERT INTO TAB_SECM_SECURECENTER_VSYS_RELATED_OBJECT
          (ID, NE_ID, VSYS_ID, OBJECT_TYPE, OBJECT_NAME)
        VALUES
          (V_UUID,
           V_NE_ID,
           V_VSYS_ID,
           'PUBLIC_INTERFACE',
           V_OBJECT_NAME);
      END IF;
    END LOOP;
    COMMA_CUR_INDEX  := 1;
    COMMA_NEXT_INDEX := 1;

    WHILE COMMA_NEXT_INDEX > 0 LOOP
      COMMA_NEXT_INDEX := LOCATE(',', V_IMPORT_FLOWS, COMMA_CUR_INDEX);
      IF COMMA_CUR_INDEX = COMMA_NEXT_INDEX THEN
        COMMA_CUR_INDEX := COMMA_CUR_INDEX + 1;
        CONTINUE;
      END IF;
      IF COMMA_NEXT_INDEX > 0 THEN
        V_OBJECT_NAME   :=SUBSTRING(V_IMPORT_FLOWS, COMMA_CUR_INDEX, COMMA_NEXT_INDEX - COMMA_CUR_INDEX);
        COMMA_CUR_INDEX := COMMA_NEXT_INDEX + 1;
      ELSE
        V_OBJECT_NAME :=SUBSTRING(V_IMPORT_FLOWS, COMMA_CUR_INDEX);
      END IF;
      IF (V_OBJECT_NAME IS NOT NULL AND TRIM(V_OBJECT_NAME) != '') THEN
        V_UUID := LOWER(UUID);
        V_UUID := SUBSTRING(V_UUID FROM 1 
        FOR 8)||'-'||SUBSTRING(V_UUID FROM 9 FOR 4)||'-'||SUBSTRING(V_UUID FROM 13 FOR 4)||'-'||SUBSTRING(V_UUID FROM 17 FOR 4)||'-'||SUBSTRING(V_UUID FROM 21 FOR 12);
        INSERT INTO TAB_SECM_SECURECENTER_VSYS_RELATED_OBJECT
          (ID, NE_ID, VSYS_ID, OBJECT_TYPE, OBJECT_NAME)
        VALUES
          (V_UUID, V_NE_ID, V_VSYS_ID, 'IMPORT_FLOW', V_OBJECT_NAME);
      END IF;
    END LOOP;
  END LOOP;
END;
/
