import subprocess
from datetime import datetime
import os
import sys
sys.path.append(os.path.split(os.path.abspath(__file__))[0])
import set_log
from func.upgrade.upgrade_operation_mgr.dao.upgrade_childtask_dao import UpgradeChildTaskDao


def exe(kvs):
    cur_path = os.path.split(__file__)[0]
    cur_file_name = os.path.split(__file__)[1]
    get_log_shell = os.path.join(cur_path, "..", "scripts", "get_log_dir.sh")
    _, log_dir = subprocess.getstatusoutput("sh %s" % get_log_shell)
    my_log = set_log.set_log(filename=os.path.join(log_dir, "%s.log" % cur_file_name))
    try:
        my_log.info(__file__)
        easysuite_upgrade_params = kvs.get('easysuite_upgrade_params')
        task_id = easysuite_upgrade_params.get('task_id')
        sub_task_id = easysuite_upgrade_params.get('sub_task_id')
        child_task_id = easysuite_upgrade_params.get('child_task_id')
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = "[%s] Please see the db report in /opt/oss/post_upgrade_report/db_difference_report/result\n" % end_time
        if os.path.exists("/opt/oss/post_upgrade_report/service_difference_report/service_difference_report.xlsx"):
            msg += "[%s] The Service differences exist. Please see the " \
                   "service report in /opt/oss/post_upgrade_report/service_difference_report" % end_time
        else:
            msg += "[%s] The Service differences do not exist" % end_time
        command = "sh %s" % (os.path.join(cur_path, "zip_upgrade_scripts.sh"))
        result = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'finish'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
    except:
        my_log.exception("Excepion logged")
        result = 1
    if result != 0:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = "[%s] compare service failed" % end_time
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'error'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return False
    else:
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'remain_time': '0'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'progress': '100'})
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'status': 'finish'})
        print(UpgradeChildTaskDao.query(task_id, sub_task_id, child_task_id))
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg})
        return True
