#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
if [[ $(echo "$EXEC_HOME"  | grep -E "\s+") ]]
then
    echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "The path contains spaces: ${EXEC_HOME}"
    exit 1
fi
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log

function delete_old_instance(){
    if [[ -f $EXEC_HOME/old_dbinstance.txt ]]
    then
        rm $EXEC_HOME/old_dbinstance.txt
    fi

    if [[ -d /opt/oss/NCECOMMONE/apps ]]
    then
        tenant_name=NCECOMMONE
    else
        tenant_name=NCE
    fi

    /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant $tenant_name|grep -e dcnnecommondb -e ncelocaldb -e ncecommondb -e ncesecmdb -e unicollectdbsvr|grep Master|awk '{print $1 "\t" $6}' >> $EXEC_HOME/old_dbinstance.txt

    cat $EXEC_HOME/old_dbinstance.txt|while read line
    do
        instname=`echo $line|awk '{print $1}'`
        echo $instname
        ip=`echo $line|awk '{print $2}'`
        echo $ip
        ssh -o StrictHostKeyChecking=no ossadm@$ip << EOF
        /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd delete-db-instance -instid $instname
        exit
EOF
    done

    # 删除冗余redis
    if [[ -f $EXEC_HOME/dbinstance_redis.txt ]]
    then
        rm $EXEC_HOME/dbinstance_redis.txt
    fi
    result_status=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${EXEC_HOME}/../scripts/pyscripts/');import restore_redis_info;print(restore_redis_info.main('rollback', '${EXEC_HOME}'))")

    if [[ $? == "0" ]]
    then
        if [[ ${result_status} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "restore redis info success."
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "restore redis info failed."
            exit 1
        fi
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "restore redis info failed."
        exit 1
    fi

    cp -rf $EXEC_HOME/dbinstance_redis.txt ${log_dir}
    cp -rf $EXEC_HOME/dbinstance_redis_all.txt ${log_dir}
    cat $EXEC_HOME/dbinstance_redis.txt|while read line
    do
        instname=`echo $line|awk '{print $1}'`
        echo $instname
        ip=`echo $line|awk '{print $2}'`
        echo $ip
        ssh -o StrictHostKeyChecking=no ossadm@$ip << EOF
        /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd delete-db-instance -instid $instname
        exit
EOF
    done


}

function main()
{
    echo echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "delete_old_instance"
    delete_old_instance
    # 刷新数据库缓存
    bash /opt/oss/manager/apps/UniEPAgent/bin/updatebackupcache.sh -type deploydata
}

main >> ${log_file} 2>&1
