#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
#接收参数
standby_ip=$1
standby_ip_pwd=$2
standby_ip_pwd=$(perl -e 'print quotemeta shift(@ARGV)' -- "${standby_ip_pwd}")
sopuser_pwd=$3
sopuser_pwd=$(perl -e 'print quotemeta shift(@ARGV)' -- "${sopuser_pwd}")
root_pwd=$4
root_pwd=$(perl -e 'print quotemeta shift(@ARGV)' -- "${root_pwd}")
temporary_path=${5}
file_name=${6}
file_name_standy=${file_name}_standy.flag
result_flag=${temporary_path}/${file_name}.flag
self_name="${0##*/}"
log_dir=`sh ${CUR_PATH}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}

function main()
{
    expect <<EOF
        set timeout -1
        spawn ssh sopuser@${standby_ip}
        expect {
            "password" {send -- "${sopuser_pwd}\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect {
            ">" { send "su - root\n";}
            "~]" { send "su - root\n";}
        }
        expect "Password:" { send -- "${root_pwd}\n" }
        expect "#" { send "cp $result_flag /home/sopuser/${file_name_standy}\n" }
        expect "#" { send "chown sopuser:ossgroup /home/sopuser/${file_name_standy}\n" }
        expect "#" { send "exit\n" } expect eof
EOF
    wait
    expect <<EOF
        set timeout -1
        spawn su - root
        expect "Password:" { send -- "${root_pwd}\n" }
        expect "#" { send "rm -rf ${temporary_path}/${file_name_standy}\n" }
        expect "yes/no" {send "yes\r"}
        expect "#" { send "scp sopuser@\[$standby_ip\]:/home/sopuser/${file_name_standy} ${temporary_path}\n" }
        expect {
            "password" {send -- "${sopuser_pwd}\n";}
            "yes/no" {send "yes\n";exp_continue}
        }
        expect "#" { send "chown ossadm:ossgroup ${temporary_path}/${file_name_standy}\n" }
        expect "#" { send "exit\n" } expect eof
EOF
    wait
}

main >> ${log_file} 2>&1

