#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
root_info=$1
function main()
{
    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${EXEC_HOME}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}" | tee -a ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed" | tee -a ${log_file}
            exit 1
    fi

    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh -o ServerAliveInterval=60 ossadm@${ip} <<EOF
            sudo -u ossuser rm -rf /tmp/handle_buildin_pkg_flag
            sudo -u ossuser touch /tmp/handle_buildin_pkg_flag
            exit
EOF
    done
}
main >> ${log_file} 2>&1
