from datetime import datetime
import os
import sys
import subprocess
sys.path.append(os.path.split(os.path.abspath(__file__))[0])
import set_log
from func.upgrade.upgrade_operation_mgr.dao.upgrade_childtask_dao import UpgradeChildTaskDao


def exe(kvs):
    modify_dict = {'remain_time': '0', 'progress': '100', 'status': 'finish'}
    cur_path = os.path.split(__file__)[0]
    cur_file_name = os.path.split(__file__)[1]
    get_log_shell = os.path.join(cur_path, "..", "scripts", "get_log_dir.sh")
    _, log_dir = subprocess.getstatusoutput("sh %s" % get_log_shell)
    my_log = set_log.set_log(filename=os.path.join(log_dir, "%s.log" % cur_file_name))
    easysuite_upgrade_params = kvs.get('easysuite_upgrade_params')
    task_id = easysuite_upgrade_params.get('task_id')
    sub_task_id = easysuite_upgrade_params.get('sub_task_id')
    child_task_id = easysuite_upgrade_params.get('child_task_id')
    result = 1
    start_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
    msg = "[%s] Start to import operation log" % start_time
    try:
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, {'msg': msg, 'status': 'running'})
        command = "sh %s %s %s" % (
            os.path.join(cur_path, "../scripts/exp_imp_data/import_data_common.sh"), "dcnnwcommondb", "auditlogdb")
        result = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
    except:
        my_log.exception("Excepion logged")
    if result != 0:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] import operation log failed" % end_time
        modify_dict["status"] = "error"
        modify_dict["msg"] = msg
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
        return False
    else:
        end_time = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        msg = msg + '\n' + "[%s] import operation log successfully" % end_time
        modify_dict["msg"] = msg
        UpgradeChildTaskDao.modify(task_id, sub_task_id, child_task_id, modify_dict)
        return True
