#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
os_pkg_tar=$2
os_pkg_gz=$3
os_pkg_patch=$4
self_name="${0##*/}"
log_dir=`sh ${CUR_PATH}/../scripts/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
temporary_dir=$(sh ${CUR_PATH}/../scripts/get_temporary_dir.sh)
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is ${2} ${3} ${4}" >> ${log_file}
master_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${CUR_PATH}/../scripts/pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('0'))"`


function start_install_os_patch()
{
    local ip=${1}
    local upgrade_sudo_pkg=${2}
    export TMOUT=100000
    ssh -o ServerAliveInterval=60 ossadm@${ip} <<EOF
        [[ ! -d ${log_dir} ]] && mkdir -p ${log_dir}
        [[ ! -d ${temporary_dir} ]] && mkdir -p ${temporary_dir}
        rm -rf ${log_dir}/query_os_src.txt
        uname -r > ${log_dir}/query_os_src.txt
        sudo ${SUPER_ROOT}/execute.sh ${temporary_dir}/${upgrade_sudo_pkg} ${temporary_dir}/start_upgrade_os_online start_upgrade_os_online.sh ${os_pkg_tar} ${os_pkg_gz} ${os_pkg_patch} ${ip} ${temporary_dir}
        exit
EOF
    if [[ $? -ne 0 ]];then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "exec start_upgrade_os_online.sh failed"
        exit 1
    fi
}

function get_failed_ips()
{
    local IPS_UN_ORDER=${1}
    local os_upgrade_online_result_dir=${2}
    failed_ips=${IPS_UN_ORDER}
    # 处理failed_ips(逗号和顺序), 对failed_ips进行排序，omp节点IP排在最后面
    failed_ips=`${PYTHONHOME}/bin/python -c "print('${failed_ips}'.strip(','))"`
    failed_ips=`${PYTHONHOME}/bin/python -c "ip_list=[ip for ip in '${failed_ips}'.split(',') if '${master_ip}' != ip.rsplit(':', 1)[0]];ip_list.append('${master_ip}'+':9094');print(','.join(ip_list))"`
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "sort failed_ips successfully: ${failed_ips}" >> ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "sort failed_ips failed" >> ${log_file}
            exit 1
    fi

    if [[ -d ${os_upgrade_online_result_dir} ]]
    then
        # 如果目录不为空
        if [[ ! -z $(ls -A ${os_upgrade_online_result_dir}) ]]
        then
            for file in ${os_upgrade_online_result_dir}/*;do
                result=`cat $file | grep "success"`
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "$file content: ${result}" >> ${log_file}
                if [[ "${result}X" != "X" ]]
                then
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "os install $file successful" >> ${log_file}
                    success_ip=`${PYTHONHOME}/bin/python -c "print('$file'.split('.txt')[0].split('_')[-1])"` >> ${log_file}
                    result=$?
                    if [[ ${result} == "0" ]]
                        then
                            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get success_ip successfully: ${success_ip}" >> ${log_file}
                        else
                            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get success_ip failed" >> ${log_file}
                            exit 1
                    fi
                    failed_ips=`${PYTHONHOME}/bin/python -c "ip_list=[ip for ip in '${failed_ips}'.split(',') if '${success_ip}' != ip.rsplit(':', 1)[0]];print(','.join(ip_list))"`
                    if [[ ${result} == "0" ]]
                        then
                            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "deal failed_ips successfully: ${failed_ips}" >> ${log_file}
                        else
                            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "deal failed_ips failed" >> ${log_file}
                            exit 1
                    fi
                else
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "os install $file failed" >> ${log_file}
                fi
            done
        fi
    fi

    echo ${failed_ips}
}


function main()
{
    os_upgrade_online_result_dir=${temporary_dir}/os_upgrade_online_result
    if [[ ! -d ${os_upgrade_online_result_dir} ]]
    then
        mkdir -p ${os_upgrade_online_result_dir}
    fi
    upgrade_sudo_pkg=upgrade_sudo_pkg.tar

    . /opt/oss/manager/agent/bin/engr_profile.sh
    # 用户手动上传软件包，有时会忘记修改权限
    sudo ${SUPER_ROOT}/execute.sh ${CUR_PATH}/${upgrade_sudo_pkg} ${temporary_dir}/modify_ospatch_permission modify_ospatch_permission.sh ${os_pkg_tar}
    if [[ $? -ne 0 ]];then
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "modify ospatch permission failed"
        exit 1
    fi

    # 获取节点IP（线上版）
    IPS_UN_ORDER=$(python ${CUR_PATH}/../scripts/pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS_UN_ORDER successfully: ${IPS_UN_ORDER}" | tee -a ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS_UN_ORDER failed" | tee -a ${log_file}
            exit 1
    fi

    failed_ips=$(get_failed_ips ${IPS_UN_ORDER} ${os_upgrade_online_result_dir})
    if [[ $? == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "exec function get_failed_ips successfully: ${failed_ips}"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "exec function get_failed_ips failed"
            exit 1
    fi

    if [[ -z ${failed_ips} ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "all nodes upgrade os success"
        exit 0
    fi

    # 拷贝OS补丁包
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success copy os_patch_package"
    IPS_array=(${failed_ips//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        retry_times=3
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start copy file"
        for((i=1;i<=${retry_times};i++))
        do
            echo ${ip}
            [[ ! -d ${temporary_dir} ]] && mkdir -p ${temporary_dir}
            scp /opt/upgrade/${os_pkg_tar} ossadm@[$ip]:/opt/oss
            scp ${CUR_PATH}/${upgrade_sudo_pkg} ossadm@[$ip]:${temporary_dir}
            result1=$?
            if [[ ${result1} == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success copy file"
                break
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "failed copy file, retry_times: ${i}"
                if [[ ${i} -eq ${retry_times} ]]
                then
                    exit 1
                fi
                sleep 10
            fi
        done
    done
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success copy os_patch_package"


    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start install os_patch"
    retry_times=3
    for((i=1;i<=${retry_times};i++))
    do
        is_success=0
        failed_ips_array=(${failed_ips//,/ })
        # os升级
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "exec start_install_os_patch"
        for ip_port in ${failed_ips_array[@]}
        do
            {
            ip_port_array=(${ip_port//:9094/ })
            ip=${ip_port_array[0]}
            echo ${ip}
            start_install_os_patch ${ip} ${upgrade_sudo_pkg} || exit 1
            }&
        sleep 5
        done
        wait

        #将结果取回omp
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get os_result"
        for ip_port in ${failed_ips_array[@]}
        do
            ip_port_array=(${ip_port//:9094/ })
            ip=${ip_port_array[0]}
            echo ${ip}
            scp ossadm@\[$ip\]:${temporary_dir}/os_online_upgrade_result_${ip}.txt ${os_upgrade_online_result_dir}
            if [[ $? == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "scp ${temporary_dir}/os_online_upgrade_result_${ip}.txt success"
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "scp ${temporary_dir}/os_online_upgrade_result_${ip}.txt failed, retry_times: ${i}"
                is_success=1
            fi
        done

        if [[ ${is_success} != "0" ]]
        then
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 5
            continue
        fi

        # 获取失败IP
        failed_ips=$(get_failed_ips ${IPS_UN_ORDER} ${os_upgrade_online_result_dir})
        if [[ $? == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get failed_ip successfully: ${failed_ips}"
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get failed_ip failed, retry_times: ${i}"
                exit 1
        fi

        if [[ ! -z ${failed_ips} ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${failed_ips} nodes upgrade os failed, retry_times: ${i}"
            is_success=1
        fi

        if [[ ${is_success} != "0" ]]
        then
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 5
            continue
        fi
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "upgrade os success"
        break
    done


    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start remove os_patch package"
    IPS_array=(${IPS_UN_ORDER//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        retry_times=3
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start remove file"
        for((i=1;i<=${retry_times};i++))
        do
            echo ${ip}
            ssh -o StrictHostKeyChecking=no ossadm@${ip} rm -rf /opt/oss/${os_pkg_tar}
            if [[ $? == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success remove file"
                break
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "failed remove file, retry_times: ${i}"
                if [[ ${i} -eq ${retry_times} ]]
                then
                    exit 1
                fi
                sleep 10
            fi
        done
    done
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success remove os_patch package"

}

main >> ${log_file} 2>&1
